"""
CS106AP Summer 2019
Written by Sonja Johnson-Yu
7.15.19 + 7.31.19
"""
import sys


def get_animal_feedings(filename):
    """
    Returns a dict of animals (not including the bears) and
    corresponding number of times the animals have been fed.

    Input:
        filename (string): file of zoo animals

    Return:
        animal_feedings (dict): animal names to num_feedings
    """
    animal_feedings = {}
    with open(filename, 'r') as f:
        for line in f:
            line = line.strip()
            split_line = line.split(',')
            if split_line[1] == 'bear':
                continue

            animal_feedings[split_line[0]] = len(split_line[3:])

    return animal_feedings


def animal_min_feedings(animal_dict):
    """
    Returns the animal that eats the fewest times per day.

    Input:
        animal_dict (dict): animal names to num_feedings

    Returns:
        name (string): name of animal that eats least frequently
        min_feedings (int): number of times animal eats per day
    """
    # TODO: modify this function to use a lambda!
    name, min_feedings = None, float('inf')
    for animal, num_feedings in animal_dict.items():
        if num_feedings < min_feedings:
            name, min_feedings = animal, num_feedings
    return name, min_feedings


def print_hungriest_animal(filename):
    """
    Prints the animal that eats least frequently.
    Input:
        filename (string): file of zoo animals
    """
    animal_dict = get_animal_feedings(filename)
    animal, num = animal_min_feedings(animal_dict)
    print(animal, 'eats', num, 'times a day.')


def main():
    args = sys.argv[1:]
    # Usage: python3 ZooFeedingsTuples.py zoo.txt
    if len(args) == 1:
        filename = args[0]
        print_hungriest_animal(filename)



if __name__ == '__main__':
    main()