from simpleimage import SimpleImage


def double_left(filename):
    """
    Take the left half of the image.
    Copy it on top of the right half.
    Assume the image width is even.
    A classic make-a-drawing situation.
    """
    image = SimpleImage(filename)

    return image


def double_left_up(filename):
    """
    Copy the left half on top of the
    right half as before, except the
    right half should be upside down.
    """
    image = SimpleImage(filename)

    return image


def copies_2(filename):
    """
    Create a new 'out' image twice as wide as the original.
    Place 2 copies of the original in out side by side,
    and return it.
    """
    image = SimpleImage(filename)
    # Creates a new white image with nothing in it
    out = SimpleImage.blank(width=image.width * 2, height=image.height)

    return out


def squeeze_width(filename, n):
    """
    A sort of funhouse-mirror effect.
    Create a new 'out' image the same height as the original,
    but with width divided by int n.
    Copy the original image to out, squeezing it horizontally
    by a factor of n, e.g. for n of 4, copy from the original
    at x 0, 4, 8, ... and so on.
    n=1 should copy the image without squeezing.
    """
    image = SimpleImage(filename)
    out = SimpleImage.blank(width=image.width // n, height=image.height)

    return out


def main():
    double_left_quad = double_left('images/quad.png')
    double_left_quad.show()
    double_left_up_quad = double_left_up('images/quad.png')
    double_left_up_quad.show()
    car_copies = copies_2('images/car.png')
    car_copies.show()
    mtl_squezed = squeeze_width('images/mtl.png', 4)
    mtl_squezed.show()


if __name__ == '__main__':
    main()