/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.autograder;

import acm.graphics.GContainer;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.gui.IntField;
import acm.gui.TableLayout;
import acm.program.ConsoleProgram;
import acm.program.GraphicsProgram;
import acm.program.Program;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import stanford.cs106.diff.DiffGui;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.io.IOUtils;
import stanford.cs106.io.ResourceUtils;
import stanford.cs106.junit.JUnitUtils;
import stanford.cs106.program.ProgramUtils;
import stanford.cs106.reflect.ReflectionRuntimeException;
import stanford.cs106.reflect.ReflectionUtils;
import stanford.cs106.util.StringUtils;
import stanford.spl.AutograderUnitTestGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuidedAutograder
implements ActionListener,
ChangeListener {
    protected static Class<? extends Program> STUDENT_CLASS = Program.class;
    protected static Class<?>[] REFLECTION_PANEL_CLASSES = new Class[]{STUDENT_CLASS};
    protected static Class<?>[] LAUNCH_CLASSES = new Class[]{STUDENT_CLASS};
    protected static Class<?>[] JUNIT_CLASSES = new Class[0];
    protected static List<String> USER_INPUTS_ADDITIONAL = new ArrayList<String>();
    protected static String VERSION = "1.0";
    protected static String AUTHOR = "Marty Stepp";
    protected static String TITLE = "";
    protected static Color GRID_LINE_COLOR = new Color(24, 157, 135);
    protected static String INPUTS_DIR = "inputs/";
    protected static String LATE_DAYS_FILE = "lateDays.txt";
    protected static String ASSERT_OUTPUT_PREFIX = "  * ";
    protected static boolean SHOW_WINDOW_PANEL = true;
    protected static boolean SHOW_FONT_PANEL = true;
    protected static boolean SHOW_DELAY_PANEL = true;
    protected static boolean SHOW_REFLECTION_PANELS = true;
    protected static boolean SHOW_REFLECTION_FIELDS = true;
    protected static boolean SHOW_REFLECTION_METHODS = true;
    protected static boolean SHOW_MESSAGELOG_PANEL = true;
    protected static boolean SHOW_INPUT_INJECT_PANEL = true;
    protected static boolean SHOW_USER_INPUT_PANEL = true;
    protected static boolean SHOW_RANDOM_PANEL = true;
    protected static boolean SHOW_JUNIT_PANEL = false;
    protected static boolean SHOW_INIT_RUN_BOXES = true;
    private static final int DEFAULT_WIDTH = 754;
    private static final int DEFAULT_HEIGHT = 492;
    protected static int MESSAGE_LOG_ROWS = 5;
    protected static int MESSAGE_LOG_COLS = 40;
    protected static Font MESSAGE_LOG_FONT = new Font("Monospaced", 0, 12);
    protected static boolean PRINT_PASSING_ASSERTS = true;
    protected static boolean SET_LOOK_AND_FEEL = true;
    protected static final Set<Class<?>> SUPPORTED_FIELD_TYPES = new HashSet();
    protected Program studentProgram = null;
    protected StudentProgramRunnerThread runnerThread = null;
    protected Container overallPanel;
    protected JCheckBox initRunBox;
    protected JCheckBox restartBox;
    protected JComboBox inputsBox;
    protected JComboBox outputsBox;
    protected JFrame autograderFrame;
    protected JScrollPane messageLogScrollPane;
    protected JSlider timeSlider;
    protected IntField randomSeedField;
    protected IntField randomIntField;
    protected JCheckBox uppercaseBox;
    protected JTextArea messageLog;
    protected Map<String, Container> panelTable = new HashMap<String, Container>();
    protected Map<Class<?>, ReflectionPanel> reflectionPanels = new HashMap();
    protected int labelWidth;
    protected int windowWidth = 754;
    protected int windowHeight = 492;
    protected int passCount = 0;
    protected int failCount = 0;
    protected LookAndFeel lookAndFeel = UIManager.getLookAndFeel();

    static {
        SUPPORTED_FIELD_TYPES.add(Integer.TYPE);
        SUPPORTED_FIELD_TYPES.add(Integer.class);
        SUPPORTED_FIELD_TYPES.add(Double.TYPE);
        SUPPORTED_FIELD_TYPES.add(Double.class);
        SUPPORTED_FIELD_TYPES.add(Boolean.TYPE);
        SUPPORTED_FIELD_TYPES.add(Boolean.class);
        SUPPORTED_FIELD_TYPES.add(Character.TYPE);
        SUPPORTED_FIELD_TYPES.add(Character.class);
        SUPPORTED_FIELD_TYPES.add(Long.TYPE);
        SUPPORTED_FIELD_TYPES.add(Long.class);
        SUPPORTED_FIELD_TYPES.add(Short.TYPE);
        SUPPORTED_FIELD_TYPES.add(Short.class);
        SUPPORTED_FIELD_TYPES.add(Byte.TYPE);
        SUPPORTED_FIELD_TYPES.add(Byte.class);
        SUPPORTED_FIELD_TYPES.add(Float.TYPE);
        SUPPORTED_FIELD_TYPES.add(Float.class);
        SUPPORTED_FIELD_TYPES.add(String.class);
        SUPPORTED_FIELD_TYPES.add(new int[0].getClass());
        SUPPORTED_FIELD_TYPES.add(new double[0].getClass());
        SUPPORTED_FIELD_TYPES.add(new char[0].getClass());
        SUPPORTED_FIELD_TYPES.add(new long[0].getClass());
        SUPPORTED_FIELD_TYPES.add(new boolean[0].getClass());
        SUPPORTED_FIELD_TYPES.add(new String[0].getClass());
    }

    public static Color getGridLineColor() {
        return GRID_LINE_COLOR;
    }

    public static void setGridLineColor(Color color) {
        GRID_LINE_COLOR = color;
    }

    public void start() {
        ResourceUtils.setResourceLoaderClass(this.getClass());
        this.createComponents();
        this.doLayout();
        this.autograderFrame.add(this.overallPanel);
        this.autograderFrame.pack();
        this.autograderFrame.setVisible(true);
        if (!SET_LOOK_AND_FEEL) {
            try {
                UIManager.setLookAndFeel(this.lookAndFeel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (SHOW_REFLECTION_PANELS) {
            new Thread(new FieldValueUpdateRunnable()).start();
        }
    }

    protected void createComponents() {
        Object file;
        int n;
        int n2;
        Object[] objectArray;
        GuiUtils.setSystemLookAndFeel();
        String title = STUDENT_CLASS.getName();
        if (TITLE != null && !TITLE.isEmpty()) {
            title = TITLE;
        }
        this.autograderFrame = new JFrame(String.valueOf(title) + " Autograder v" + VERSION + " by " + AUTHOR);
        GuiUtils.rememberWindowLocation(this.autograderFrame);
        this.autograderFrame.setDefaultCloseOperation(3);
        this.overallPanel = Box.createVerticalBox();
        this.initRunBox = new JCheckBox("Call init()/run()", true);
        this.initRunBox.setMnemonic('C');
        this.restartBox = new JCheckBox("Restart on constant change", true);
        this.restartBox.setMnemonic('R');
        this.timeSlider = new JSlider(1, 7);
        this.timeSlider.setValue(4);
        this.timeSlider.setMajorTickSpacing(1);
        this.timeSlider.setPaintLabels(false);
        this.timeSlider.setPaintTicks(true);
        this.timeSlider.setSnapToTicks(true);
        this.timeSlider.addChangeListener(this);
        this.timeSlider.setPreferredSize(new Dimension(100, this.timeSlider.getPreferredSize().height));
        this.randomSeedField = new IntField();
        this.randomSeedField.setActionCommand("Random seed");
        this.randomIntField = new IntField(0);
        this.randomIntField.setActionCommand("Random int");
        this.inputsBox = new JComboBox();
        this.inputsBox.setEditable(false);
        this.inputsBox.addItem("(select a script)");
        Object[] files = new File(INPUTS_DIR).listFiles();
        if (files != null && files.length > 0) {
            Arrays.sort(files);
            objectArray = files;
            n2 = files.length;
            n = 0;
            while (n < n2) {
                file = objectArray[n];
                if (((File)file).getName().startsWith("input")) {
                    this.inputsBox.addItem(((File)file).getName().replace("input-", "").replace(".txt", ""));
                }
                ++n;
            }
        }
        this.outputsBox = new JComboBox();
        this.outputsBox.setEditable(false);
        this.outputsBox.addItem("(select an output)");
        if (files != null && files.length > 0) {
            objectArray = files;
            n2 = files.length;
            n = 0;
            while (n < n2) {
                file = objectArray[n];
                if (((File)file).getName().startsWith("expected")) {
                    this.outputsBox.addItem(((File)file).getName().replace("expected-", "").replace(".txt", ""));
                }
                ++n;
            }
        }
        this.uppercaseBox = new JCheckBox("Uppercase?", true);
        this.messageLog = new JTextArea(MESSAGE_LOG_ROWS, MESSAGE_LOG_COLS);
        this.messageLog.setFont(MESSAGE_LOG_FONT);
        this.messageLog.setEditable(false);
        this.messageLogScrollPane = new JScrollPane(this.messageLog);
        this.messageLogScrollPane.setHorizontalScrollBarPolicy(31);
        this.messageLogScrollPane.setVerticalScrollBarPolicy(20);
        this.displayLateness();
    }

    protected Container doLayout() {
        int taller;
        Class<?>[] launchButton;
        Class<?> clazz;
        int GAP = 15;
        ArrayList<Component> launchButtons = new ArrayList<Component>();
        Class<?>[] classArray = LAUNCH_CLASSES;
        int n = LAUNCH_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            clazz = classArray[n2];
            launchButton = GuiUtils.createButton("Launch " + clazz.getName(), 'B', this);
            Font buttonFont = launchButton.getFont();
            launchButton.setFont(buttonFont.deriveFont(1, (float)buttonFont.getSize() + 2.0f));
            int wider = 10;
            taller = 16;
            Dimension launchSize = new Dimension(launchButton.getPreferredSize().width + wider, launchButton.getPreferredSize().height + taller);
            launchButton.setPreferredSize(launchSize);
            launchButtons.add((Component)launchButton);
            ++n2;
        }
        if (SHOW_INIT_RUN_BOXES) {
            launchButtons.add(Box.createHorizontalStrut(10));
            launchButtons.add(this.initRunBox);
            launchButtons.add(this.restartBox);
            this.addPanel("Launch", launchButtons);
        } else {
            this.addPanel("Launch", (LayoutManager)new FlowLayout(1), launchButtons);
        }
        this.labelWidth = new JLabel((String)"JUnit automated tests: ").getPreferredSize().width;
        if (SHOW_JUNIT_PANEL) {
            JPanel junitPanel = new JPanel();
            launchButton = JUNIT_CLASSES;
            int n3 = JUNIT_CLASSES.length;
            n = 0;
            while (n < n3) {
                Class<?> clazz2 = launchButton[n];
                String className = clazz2.getName();
                JButton junitClassButton = GuiUtils.createButton(className, "Run JUnit " + className, ' ', this);
                junitClassButton.setFont(junitClassButton.getFont().deriveFont(1));
                junitPanel.add(junitClassButton);
                ++n;
            }
            this.addPanel("JUnit tests", GuiUtils.createLabel("JUnit automated tests: ", this.labelWidth), junitPanel);
        }
        if (SHOW_WINDOW_PANEL) {
            this.addPanel("Window", GuiUtils.createLabel("Window: ", this.labelWidth), GuiUtils.createButton("420x600px (Default)", "Default window size", 'D', this), GuiUtils.createButton("700x500px", "Wide window size", ' ', this), GuiUtils.createButton("300x700px", "Tall window size", ' ', this));
        }
        if (SHOW_DELAY_PANEL) {
            this.addPanel("Delay", GuiUtils.createLabel("DELAY: ", this.labelWidth, true), GuiUtils.createButton("Default", "Default DELAY", 'u', this), GuiUtils.createButton("1ms", "1ms DELAY", ' ', this), GuiUtils.createButton("5ms", "5ms DELAY", ' ', this), GuiUtils.createButton("100ms", "100ms DELAY", ' ', this), GuiUtils.createButton("1s", "1000ms DELAY", ' ', this), this.timeSlider, GuiUtils.createButton("Tick", "Tick", 'T', this));
        }
        this.doExtraLayout();
        if (SHOW_INPUT_INJECT_PANEL) {
            this.addPanel("Inputs", GuiUtils.createLabel("Input scripts: ", this.labelWidth), this.inputsBox, GuiUtils.createButton("Inject", "Inject input", 'I', this), Box.createHorizontalStrut(15), new JLabel("outputs: "), this.outputsBox, GuiUtils.createButton("Diff", "Diff output", 'D', this), Box.createHorizontalStrut(15), GuiUtils.createButton("Clear console", ' ', this));
        }
        if (SHOW_USER_INPUT_PANEL) {
            String inputs = "Yes A B C D E F G H I J K L M ? Enter No  N O P Q R S T U V W X Y Z . Space";
            int additionalGridWidth = 2;
            int cols = 16;
            int rows = 2 + (int)Math.ceil((double)USER_INPUTS_ADDITIONAL.size() / (double)cols / (double)additionalGridWidth);
            JPanel userInputPanel = new JPanel(new TableLayout(rows, cols));
            String[] stringArray = inputs.split("[ \t]+");
            taller = stringArray.length;
            int n4 = 0;
            while (n4 < taller) {
                String input = stringArray[n4];
                JButton inputButton = GuiUtils.createButton(input, "User input " + input, ' ', this);
                Dimension size = inputButton.getPreferredSize();
                if (size.width < size.height) {
                    size.width = size.height;
                    inputButton.setPreferredSize(size);
                }
                userInputPanel.add(inputButton);
                ++n4;
            }
            for (String input : USER_INPUTS_ADDITIONAL) {
                JButton inputButton = GuiUtils.createButton(input, "User input " + input, ' ', this);
                userInputPanel.add((Component)inputButton, "gridwidth=" + additionalGridWidth);
            }
            int i = 0;
            while (i < cols - USER_INPUTS_ADDITIONAL.size() % cols * additionalGridWidth) {
                userInputPanel.add(new JPanel());
                ++i;
            }
            this.addPanel("User input", GuiUtils.createLabel("User input: ", this.labelWidth), userInputPanel, this.uppercaseBox);
        }
        if (SHOW_RANDOM_PANEL) {
            this.addPanel("RandomGenerator", new JLabel("RandomGenerator: "), new JLabel("Seed: "), this.randomSeedField, GuiUtils.createButton("Set", "Random seed", 'R', this), GuiUtils.createButton("Unset", "Random seed unset", 'u', this), Box.createHorizontalStrut(15), new JLabel("Fixed int: "), this.randomIntField, GuiUtils.createButton("Set", "Random int", ' ', this), GuiUtils.createButton("Unset", "Random int unset", 'n', this));
        }
        if (SHOW_REFLECTION_PANELS) {
            classArray = REFLECTION_PANEL_CLASSES;
            n = REFLECTION_PANEL_CLASSES.length;
            int n5 = 0;
            while (n5 < n) {
                clazz = classArray[n5];
                ReflectionPanel panel = new ReflectionPanel(clazz);
                panel.doLayout();
                this.reflectionPanels.put(clazz, panel);
                ++n5;
            }
        }
        if (SHOW_MESSAGELOG_PANEL) {
            this.addPanel("Message Log", new JLabel("Message Log:"));
            this.overallPanel.add(this.messageLogScrollPane);
        }
        return this.overallPanel;
    }

    protected void doExtraLayout() {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand().intern();
        if (cmd.startsWith("Launch ")) {
            String className = cmd.replace("Launch ", "");
            this.studentProgramThreadLaunch(className);
        } else if (cmd.startsWith("Run JUnit ")) {
            String className = cmd.replace("Run JUnit ", "");
            this.junitLaunch(className);
        } else if (cmd != "Default window size") {
            if (cmd == "Wide window size") {
                this.constantsSetAllWindow(700, 500);
            } else if (cmd == "Tall window size") {
                this.constantsSetAllWindow(300, 700);
            } else if (cmd != "Tick") {
                if (cmd == "Inject input") {
                    this.injectInput();
                } else if (cmd == "Diff output") {
                    this.diffOutput();
                } else if (cmd == "Clear console") {
                    if (JOptionPane.showConfirmDialog(this.autograderFrame, "Are you sure you want to clear the console?", "Are you sure?", 0) == 0 && this.studentProgram != null) {
                        ((ConsoleProgram)this.studentProgram).getConsole().clear();
                    }
                } else if (cmd == "Random seed") {
                    int seed = this.randomSeedField.getValue();
                    ReflectionUtils.staticMethodInvoke("RandomGenerator", "setAllSeed", seed);
                    this.printlnLog("set RandomGenerator seed to " + seed);
                } else if (cmd == "Random seed unset") {
                    this.randomSeedField.setText("");
                    ReflectionUtils.staticMethodInvoke("RandomGenerator", "setAllSeed", new Object[1]);
                    this.printlnLog("unset RandomGenerator seed");
                } else if (cmd == "Random int") {
                    int rig = this.randomIntField.getValue();
                    ReflectionUtils.staticMethodInvoke("RandomGenerator", "rigInt", rig);
                    ReflectionUtils.staticMethodInvoke("RandomGenerator", "rigDouble", (double)rig);
                    this.printlnLog("set RandomGenerator so all nextInt/Double calls return " + rig);
                } else if (cmd == "Random int unset") {
                    this.randomIntField.setText("");
                    ReflectionUtils.staticMethodInvoke("RandomGenerator", "rigInt", new Object[1]);
                    ReflectionUtils.staticMethodInvoke("RandomGenerator", "rigDouble", new Object[1]);
                    this.printlnLog("unset RandomGenerator nextInt/Double fixed value");
                } else if (cmd.startsWith("User input ")) {
                    this.userInput(cmd, event);
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
    }

    protected void assertTrue(String msg, boolean b) {
        if (b) {
            if (PRINT_PASSING_ASSERTS) {
                this.printlnLog(String.valueOf(ASSERT_OUTPUT_PREFIX) + msg + ": pass");
            }
            ++this.passCount;
        } else {
            this.printlnLog(String.valueOf(ASSERT_OUTPUT_PREFIX) + msg + ": FAIL!");
            ++this.failCount;
        }
    }

    protected void assertFalse(String msg, boolean b) {
        this.assertTrue(msg, !b);
    }

    protected void assertEquals(String msg, Object expected, Object actual) {
        if (expected == actual || expected != null && actual != null && expected.equals(actual)) {
            if (PRINT_PASSING_ASSERTS) {
                this.printlnLog(String.valueOf(ASSERT_OUTPUT_PREFIX) + msg + ": pass");
            }
            ++this.passCount;
        } else {
            this.printlnLog(String.valueOf(ASSERT_OUTPUT_PREFIX) + msg + ": FAIL! (expected <" + expected + ">, got <" + actual + ">)");
            ++this.failCount;
        }
    }

    protected void assertPrintCounts() {
        this.assertPrintCounts(true);
    }

    protected void assertPrintCounts(boolean resetAfter) {
        int total = this.passCount + this.failCount;
        this.printlnLog("Passed " + this.passCount + " out of " + total + " tests." + (total == this.passCount ? " (all tests passed!)" : ""));
        if (resetAfter) {
            this.assertResetCounts();
        }
    }

    protected void assertResetCounts() {
        this.passCount = 0;
        this.failCount = 0;
    }

    protected JPanel addPanel(String name, Collection<Component> components) {
        return this.addPanel(name, components.toArray(new Component[0]));
    }

    protected JPanel addPanel(String name, Component ... components) {
        return this.addPanel(name, (LayoutManager)new FlowLayout(0), components);
    }

    protected JPanel addPanel(String name, LayoutManager layout, Collection<Component> components) {
        return this.addPanel(name, layout, components.toArray(new Component[0]));
    }

    protected JPanel addPanel(String name, LayoutManager layout, Component ... components) {
        JPanel panel = new JPanel(layout);
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp != null) {
                panel.add(comp);
            }
            ++n2;
        }
        this.panelTable.put(name, panel);
        this.overallPanel.add(panel);
        return panel;
    }

    protected void diffOutput() {
        if (this.studentProgram == null) {
            return;
        }
        String selected = String.valueOf(this.outputsBox.getSelectedItem());
        if (selected == null || selected.isEmpty() || selected.startsWith("(")) {
            return;
        }
        String expected = IOUtils.readEntireFile(String.valueOf(INPUTS_DIR) + "expected-" + selected + ".txt");
        String output = ProgramUtils.getConsoleOutput((ConsoleProgram)this.studentProgram);
        new DiffGui("Expected output", expected, "Student output", output).show();
    }

    protected void injectInput() {
        if (this.studentProgram == null) {
            return;
        }
        String selected = String.valueOf(this.inputsBox.getSelectedItem());
        if (selected == null || selected.isEmpty() || selected.startsWith("(")) {
            return;
        }
        this.outputsBox.setSelectedItem(selected);
        String fileText = IOUtils.readEntireFile(String.valueOf(INPUTS_DIR) + "input-" + selected + ".txt");
        ProgramUtils.injectConsoleInput((ConsoleProgram)this.studentProgram, fileText);
        this.printlnLog("loaded input script from " + selected);
    }

    protected void userInput(String cmd, ActionEvent event) {
        String userInput = cmd.replace("User input ", "").intern();
        if (userInput == "Enter") {
            userInput = "\n";
        } else if (userInput == "Space") {
            userInput = " ";
        }
        userInput = userInput.length() == 1 && this.uppercaseBox.isSelected() || (event.getModifiers() & 0x40) != 0 ? userInput.toUpperCase() : userInput.toLowerCase();
        if (!userInput.endsWith("\n")) {
            userInput = String.valueOf(userInput) + "\n";
        }
        ProgramUtils.injectConsoleInput((ConsoleProgram)this.studentProgram, userInput);
    }

    protected void studentProgramThreadKill() {
        if (this.runnerThread == null) {
            return;
        }
        if (this.runnerThread.started) {
            this.runnerThread.killMe();
            try {
                this.runnerThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            if (this.studentProgram != null) {
                this.studentProgram.stop();
            }
            this.runnerThread.nonRunKill();
            this.studentProgram = null;
        }
        this.runnerThread.started = false;
    }

    protected void studentProgramThreadLaunchIfBoxChecked() {
        if (this.restartBox.isSelected()) {
            this.studentProgramThreadLaunch();
        }
    }

    protected void studentProgramThreadLaunch() {
        this.studentProgramThreadLaunch(STUDENT_CLASS);
    }

    protected void studentProgramThreadLaunch(String className) {
        try {
            this.studentProgramThreadLaunch(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionRuntimeException(e);
        }
    }

    protected void junitLaunch(String className) {
        try {
            this.junitLaunch(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionRuntimeException(e);
        }
    }

    protected void junitLaunch(final Class<?> clazz) {
        this.studentProgramThreadKill();
        this.printlnLog("running JUnit tests from " + clazz.getName());
        final AutograderUnitTestGUI testGUI = AutograderUnitTestGUI.getInstance(null);
        testGUI.clearTestResults();
        testGUI.clearTests();
        testGUI.setCheckboxesShown(false);
        testGUI.setDescription("Click a test to see error details.");
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new ReflectionUtils.MethodNameComparator());
        final ArrayList<Method> testMethods = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (JUnitUtils.isJUnitMethod(clazz, method)) {
                String categoryName = JUnitUtils.getTestCategory(clazz, method);
                testGUI.addTest(method.getName(), categoryName);
                testMethods.add(method);
            }
            ++n2;
        }
        testGUI.setVisible(true);
        Runnable junitRunnable = new Runnable(){

            public void run() {
                for (Method method : testMethods) {
                    JUnitUtils.runJUnitMethod(clazz, method, testGUI);
                }
                testGUI.setTestingCompleted(true);
                GuidedAutograder.this.printlnLog("Passed " + testGUI.getPassedCount() + " of " + testGUI.getTestCount() + " tests.");
            }
        };
        Thread thread = new Thread(junitRunnable);
        thread.start();
    }

    protected void studentProgramThreadLaunch(Class<?> clazz) {
        this.studentProgramThreadKill();
        this.printlnLog("launching " + clazz.getName());
        this.runnerThread = new StudentProgramRunnerThread(clazz, this.windowWidth, this.windowHeight, this.initRunBox.isSelected());
        this.studentProgram = this.runnerThread.getProgram();
        this.runnerThread.init();
        this.runnerThread.start();
        try {
            this.runnerThread.join(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void constantsSetAllWindow(int width, int height) {
        this.printlnLog("setting window size to " + width + "x" + height + "px (-1 = defaults)");
        this.studentProgramThreadLaunchIfBoxChecked();
    }

    protected int constGetInt(String name) {
        return ReflectionUtils.getConstantValueInt(STUDENT_CLASS, this.studentProgram, name);
    }

    protected void constSet(String name, Object value) {
        if (ReflectionUtils.constantExists(STUDENT_CLASS, name = name.intern())) {
            ReflectionUtils.setConstantValue(STUDENT_CLASS, this.studentProgram, name, value);
        } else if (ReflectionUtils.constantExists(GraphicsProgram.class, name)) {
            ReflectionUtils.setConstantValue(GraphicsProgram.class, this.studentProgram, name, value);
        } else {
            this.printlnLog("ERROR: No constant named '" + name + "' exists in the student's classes.");
        }
    }

    protected void constSetMaybe(String name, int value, Object defaultValue) {
        if (value >= 0) {
            this.constSet(name, value);
        } else {
            this.constSet(name, defaultValue);
        }
    }

    protected void constSetMaybe(String name, double value, Object defaultValue) {
        if (value > 0.0) {
            this.constSet(name, value);
        } else {
            this.constSet(name, defaultValue);
        }
    }

    protected int getWindowWidth() {
        return this.windowWidth;
    }

    protected int getWindowHeight() {
        return this.windowHeight;
    }

    protected void setWindowWidth(int width) {
        this.windowWidth = width;
    }

    protected void setWindowHeight(int height) {
        this.windowHeight = height;
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void displayLateness() {
        File lateDaysFile = new File(LATE_DAYS_FILE);
        if (lateDaysFile.exists()) {
            try {
                Scanner input = new Scanner(lateDaysFile);
                StringBuilder sb = new StringBuilder();
                while (input.hasNextLine()) {
                    String line = input.nextLine();
                    line = line.replace("assignment_due_time: ", "assignment_due_time:     ");
                    sb.append(line);
                    sb.append('\n');
                }
                input.close();
                sb.append("=============================================");
                this.printlnLog(sb.toString());
            }
            catch (FileNotFoundException fnfe) {
                this.printlnLog("Unable to read " + LATE_DAYS_FILE + ": " + fnfe);
            }
        }
    }

    protected void gridLineAdd(GContainer container, double x1, double y1, double x2, double y2) {
        GLine line = new GLine(x1, y1, x2, y2);
        line.setColor(GRID_LINE_COLOR);
        container.add(line);
    }

    protected void gridLineAdd(double x1, double y1, double x2, double y2) {
        GLine line = new GLine(x1, y1, x2, y2);
        line.setColor(GRID_LINE_COLOR);
        if (this.studentProgram instanceof GraphicsProgram) {
            GraphicsProgram graphicsProgram = (GraphicsProgram)this.studentProgram;
            graphicsProgram.add(line);
        }
    }

    protected boolean gridLinesExist(GContainer container) {
        if (container == null) {
            return false;
        }
        int i = 0;
        while (i < container.getElementCount()) {
            GObject gobj = container.getElement(i);
            if (gobj.getColor().equals(GRID_LINE_COLOR)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean gridLinesExist() {
        if (this.studentProgram == null) {
            return false;
        }
        if (this.studentProgram instanceof GraphicsProgram) {
            GraphicsProgram graphicsProgram = (GraphicsProgram)this.studentProgram;
            Iterator<GObject> itr = graphicsProgram.iterator();
            while (itr.hasNext()) {
                GObject obj = itr.next();
                if (!(obj instanceof GObject) || !obj.getColor().equals(GRID_LINE_COLOR)) continue;
                return true;
            }
        }
        return false;
    }

    protected void gridLineRemoveAll(GContainer container) {
        if (container == null) {
            return;
        }
        HashSet<GObject> toRemove = new HashSet<GObject>();
        int i = 0;
        while (i < container.getElementCount()) {
            GObject gobj = container.getElement(i);
            if (gobj instanceof GObject && gobj.getColor().equals(GRID_LINE_COLOR)) {
                toRemove.add(gobj);
            }
            ++i;
        }
        for (GObject line : toRemove) {
            container.remove(line);
        }
        this.printlnLog("Grid lines removed.");
    }

    protected void gridLineRemoveAll() {
        if (this.studentProgram == null) {
            return;
        }
        if (this.studentProgram instanceof GraphicsProgram) {
            GraphicsProgram graphicsProgram = (GraphicsProgram)this.studentProgram;
            HashSet<GLine> toRemove = new HashSet<GLine>();
            Iterator<GObject> itr = graphicsProgram.iterator();
            while (itr.hasNext()) {
                GObject obj = itr.next();
                if (!(obj instanceof GLine) || !((GLine)obj).getColor().equals(GRID_LINE_COLOR)) continue;
                toRemove.add((GLine)obj);
            }
            for (GLine line : toRemove) {
                graphicsProgram.remove(line);
            }
        }
    }

    protected void printlnLog(String msg) {
        String text = this.messageLog.getText();
        if (text.length() > 0) {
            text = String.valueOf(text) + "\n";
        }
        text = String.valueOf(text) + msg;
        this.messageLog.setText(text);
        this.messageLog.setCaretPosition(text.length());
    }

    protected void updateAllReflectionPanels() {
        for (ReflectionPanel panel : this.reflectionPanels.values()) {
            panel.currentFieldValueGet();
            panel.currentConstantValueGet();
        }
    }

    private class FieldValueUpdateRunnable
    implements Runnable {
        private FieldValueUpdateRunnable() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                GuidedAutograder.this.updateAllReflectionPanels();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReflectionPanel
    implements ActionListener {
        protected Class<?> clazz;
        protected Object object;
        protected JComboBox fieldBox;
        protected JComboBox constantBox;
        protected JComboBox methodBox;
        protected JTextField fieldValueFromBox;
        protected JTextField fieldValueToBox;
        protected JTextField constantValueFromBox;
        protected JTextField constantValueToBox;
        protected Map<String, Field> fieldTable = new TreeMap<String, Field>();
        protected Map<String, Field> constantTable = new TreeMap<String, Field>();
        protected Map<String, Method> methodTable = new TreeMap<String, Method>();

        public ReflectionPanel(Class<?> clazz) {
            this(clazz, null);
        }

        public ReflectionPanel(Class<?> clazz, Object object) {
            this.clazz = clazz;
            this.object = object;
            this.fieldBox = new JComboBox();
            this.fieldBox.setEditable(false);
            this.fieldBox.setActionCommand(String.valueOf(clazz.getName()) + " Get field value");
            this.fieldBox.addActionListener(this);
            this.fieldBox.addItem("(select a field)");
            Field[] fields = clazz.getDeclaredFields();
            Arrays.sort(fields, new ReflectionUtils.FieldNameComparator());
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (SUPPORTED_FIELD_TYPES.contains(field.getType())) {
                    String fieldString = String.valueOf(ReflectionUtils.getClassNameWithoutPackage(field.getType(), field.getGenericType())) + " " + field.getName();
                    this.fieldTable.put(fieldString, field);
                    this.fieldBox.addItem(fieldString);
                }
                ++n2;
            }
            if (this.fieldBox.getItemCount() <= 1) {
                this.fieldBox.setEnabled(false);
            }
            this.fieldValueFromBox = new JTextField(8);
            this.fieldValueFromBox.setEditable(false);
            this.fieldValueToBox = new JTextField(8);
            this.fieldValueToBox.addActionListener(this);
            this.fieldValueToBox.setActionCommand(String.valueOf(clazz.getName()) + " Set field value");
            this.constantBox = new JComboBox();
            this.constantBox.setEditable(false);
            this.constantBox.setActionCommand(String.valueOf(clazz.getName()) + " Get constant value");
            this.constantBox.addActionListener(this);
            this.constantBox.addItem("(select a constant)");
            Field[] constants = clazz.getDeclaredFields();
            Arrays.sort(constants, new ReflectionUtils.FieldNameComparator());
            Field[] fieldArray2 = constants;
            int n3 = constants.length;
            n = 0;
            while (n < n3) {
                Field constant = fieldArray2[n];
                if (Modifier.isStatic(constant.getModifiers()) && SUPPORTED_FIELD_TYPES.contains(constant.getType())) {
                    String constantString = String.valueOf(ReflectionUtils.getClassNameWithoutPackage(constant.getType(), constant.getGenericType())) + " " + constant.getName();
                    this.constantTable.put(constantString, constant);
                    this.constantBox.addItem(constantString);
                }
                ++n;
            }
            if (this.constantBox.getItemCount() <= 1) {
                this.constantBox.setEnabled(false);
            }
            this.constantValueFromBox = new JTextField(8);
            this.constantValueFromBox.setEditable(false);
            this.constantValueToBox = new JTextField(8);
            this.constantValueToBox.addActionListener(this);
            this.constantValueToBox.setActionCommand(String.valueOf(clazz.getName()) + " Set constant value");
            this.methodBox = new JComboBox();
            this.methodBox.setEditable(false);
            this.methodBox.setActionCommand(String.valueOf(clazz.getName()) + " Get method value");
            this.methodBox.addActionListener(this);
            this.methodBox.addItem("(select a method)");
            Method[] methods = clazz.getDeclaredMethods();
            Arrays.sort(methods, new ReflectionUtils.MethodNameComparator());
            Method[] methodArray = methods;
            int n4 = methods.length;
            n3 = 0;
            while (n3 < n4) {
                Method method = methodArray[n3];
                String methodString = String.valueOf(ReflectionUtils.getClassNameWithoutPackage(method.getReturnType())) + " " + method.getName() + "()";
                this.methodTable.put(methodString, method);
                this.methodBox.addItem(methodString);
                ++n3;
            }
        }

        public void doLayout() {
            if (SHOW_REFLECTION_FIELDS) {
                GuidedAutograder.this.addPanel(String.valueOf(this.clazz.getName()) + " fields", GuiUtils.createLabel(String.valueOf(this.clazz.getName()) + " fields: ", GuidedAutograder.this.labelWidth), this.fieldBox, new JLabel(" from "), this.fieldValueFromBox, new JLabel(" to "), this.fieldValueToBox, GuiUtils.createButton("Set", String.valueOf(this.clazz.getName()) + " Set field value", 'S', this));
            }
            if (SHOW_REFLECTION_METHODS) {
                GuidedAutograder.this.addPanel(String.valueOf(this.clazz.getName()) + " methods", GuiUtils.createLabel(String.valueOf(this.clazz.getName()) + " methods: ", GuidedAutograder.this.labelWidth), this.methodBox, GuiUtils.createButton("Call", String.valueOf(this.clazz.getName()) + " Call method", 'C', this));
            }
        }

        public void setObject(Object object) {
            this.object = object;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand().intern();
            if (cmd.equals(String.valueOf(this.clazz.getName()) + " Get field value")) {
                this.currentFieldValueGet();
            } else if (cmd.equals(String.valueOf(this.clazz.getName()) + " Set field value")) {
                this.currentFieldValueSet();
            } else if (cmd.equals(String.valueOf(this.clazz.getName()) + " Get constant value")) {
                this.currentConstantValueGet();
            } else if (cmd.equals(String.valueOf(this.clazz.getName()) + " Set constant value")) {
                this.currentConstantValueSet();
            } else if (cmd.equals(String.valueOf(this.clazz.getName()) + " Call method")) {
                this.currentMethodCall();
            }
        }

        protected void currentFieldValueGet() {
            String fieldString = String.valueOf(this.fieldBox.getItemAt(this.fieldBox.getSelectedIndex()));
            if (fieldString == null || fieldString.equals("(select a field)")) {
                return;
            }
            Field field = this.fieldTable.get(fieldString);
            if (this.object == null && !Modifier.isStatic(field.getModifiers())) {
                return;
            }
            String fieldValueText = StringUtils.fitToWidth(String.valueOf(ReflectionUtils.getFieldValue(this.object, field)), 80);
            String currentText = this.fieldValueFromBox.getText();
            if (currentText == null || !currentText.equals(fieldValueText)) {
                this.fieldValueFromBox.setText(fieldValueText);
                this.fieldValueFromBox.setCaretPosition(0);
            }
        }

        protected void currentFieldValueSet() {
            String fieldString = this.roundDouble(String.valueOf(this.fieldBox.getItemAt(this.fieldBox.getSelectedIndex())));
            if (fieldString == null || fieldString.equals("(select a field)")) {
                return;
            }
            Field field = this.fieldTable.get(fieldString);
            if (this.object == null && !Modifier.isStatic(field.getModifiers())) {
                return;
            }
            String valueStr = this.fieldValueToBox.getText();
            try {
                Object value = ReflectionUtils.parseValue(field.getType(), field.getGenericType(), valueStr);
                ReflectionUtils.setFieldValue(this.object, field, value);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(GuidedAutograder.this.autograderFrame, "Error trying to read value:\n\n" + nfe, "Parse error", 0);
            }
            catch (IllegalArgumentException nfe) {
                JOptionPane.showMessageDialog(GuidedAutograder.this.autograderFrame, "Error trying to read value:\n\n" + nfe, "Parse error", 0);
            }
        }

        private String roundDouble(String s) {
            try {
                double d = Double.parseDouble(s);
                d = (double)Math.round(d * 10000.0) / 10000.0;
                return String.valueOf(d);
            }
            catch (NumberFormatException e) {
                return s;
            }
        }

        protected void currentConstantValueGet() {
            String constantString = String.valueOf(this.constantBox.getItemAt(this.constantBox.getSelectedIndex()));
            if (constantString == null || constantString.equals("(select a constant)")) {
                return;
            }
            Field constant = this.constantTable.get(constantString);
            String constantValueText = String.valueOf(ReflectionUtils.getConstantValue(STUDENT_CLASS, constant.getName()));
            String currentText = this.constantValueFromBox.getText();
            if (currentText == null || !currentText.equals(constantValueText)) {
                this.constantValueFromBox.setText(constantValueText);
            }
        }

        protected void currentConstantValueSet() {
            String constantString = String.valueOf(this.constantBox.getItemAt(this.constantBox.getSelectedIndex()));
            if (constantString == null || constantString.equals("(select a constant)")) {
                return;
            }
            Field constant = this.constantTable.get(constantString);
            String valueStr = this.constantValueToBox.getText();
            Object value = ReflectionUtils.parseValue(constant.getType(), constant.getGenericType(), valueStr);
            ReflectionUtils.setConstantValue(STUDENT_CLASS, constant.getName(), value);
        }

        protected void currentMethodCall() {
            String methodString = String.valueOf(this.methodBox.getItemAt(this.methodBox.getSelectedIndex()));
            if (methodString == null || methodString.equals("(select a method)")) {
                return;
            }
            Method method = this.methodTable.get(methodString);
            if (this.object == null && !Modifier.isStatic(method.getModifiers())) {
                return;
            }
            Object[] paramValues = ReflectionUtils.getDefaultArgs(method);
            try {
                method.setAccessible(true);
                method.invoke(this.object, paramValues);
            }
            catch (Throwable t) {
                GuidedAutograder.this.printlnLog("Error running method " + method.getName() + ": " + t);
                t.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StudentProgramRunnerThread
    extends Thread {
        private Class<?> clazz;
        private boolean callInitAndRun;
        public boolean started = false;
        private boolean kill = false;
        private int width;
        private int height;
        private Program program;
        private JFrame oFrame;
        private Class<?> programClass;

        public StudentProgramRunnerThread(Class<?> clazz, boolean callInitAndRun) {
            this(clazz, 754, 492, callInitAndRun);
        }

        public StudentProgramRunnerThread(Class<?> clazz, int width, int height, boolean callInitAndRun) {
            this.clazz = clazz;
            this.width = width;
            this.height = height;
            this.callInitAndRun = callInitAndRun;
            try {
                this.programClass = clazz;
                if (Program.class.isAssignableFrom(clazz)) {
                    this.program = (Program)clazz.newInstance();
                    ReflectionPanel panel = GuidedAutograder.this.reflectionPanels.get(STUDENT_CLASS);
                    if (panel != null) {
                        panel.setObject(this.program);
                    }
                }
            }
            catch (InstantiationException ie) {
                throw new ReflectionRuntimeException(ie);
            }
            catch (IllegalAccessException ie) {
                throw new ReflectionRuntimeException(ie);
            }
        }

        public Program getProgram() {
            return this.program;
        }

        public JFrame getFrame() {
            return this.oFrame;
        }

        public void init() {
            if (this.program != null) {
                this.oFrame = new JFrame(this.clazz.getName());
                GuiUtils.rememberWindowLocation(this.oFrame);
                this.oFrame.setVisible(true);
                this.oFrame.setDefaultCloseOperation(1);
                Insets insets = this.oFrame.getInsets();
                this.oFrame.setSize(this.width + insets.left + insets.right, this.height + insets.top + insets.bottom);
                this.oFrame.add((Component)this.program, "Center");
                this.program.setSize(754, 492);
            }
        }

        public void nonRunKill() {
            if (this.oFrame != null) {
                this.oFrame.setVisible(false);
                this.oFrame.dispose();
            }
        }

        public void killMe() {
            Program program = this.getProgram();
            if (program != null) {
                program.stop();
            }
            this.kill = true;
        }

        @Override
        public void run() {
            try {
                if (this.program == null && this.programClass != null) {
                    String[] args = new String[]{};
                    Method main = this.programClass.getMethod("main", args.getClass());
                    if (main != null) {
                        main.invoke(null, new Object[]{args});
                    }
                } else {
                    if (this.callInitAndRun) {
                        this.program.init();
                    }
                    this.oFrame.setVisible(true);
                    this.program.setVisible(true);
                    this.oFrame.validate();
                    this.oFrame.repaint();
                    if (this.callInitAndRun) {
                        this.program.run();
                    }
                }
            }
            catch (Error e) {
                GuidedAutograder.this.printlnLog(e.toString());
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            while (!this.kill) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.oFrame != null) {
                this.oFrame.setVisible(false);
                this.oFrame.dispose();
            }
        }
    }
}

