/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import stanford.cs106.gui.GuiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOptionPane
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private JList list;
    private JButton ok;
    private JButton cancel;
    private boolean pressedOk = false;

    public ListOptionPane(JFrame frame, Collection<String> items) {
        super((Frame)frame, true);
        this.setTitle("Load...");
        this.list = new JList<Object>(items.toArray());
        this.list.setSelectionMode(2);
        this.list.setVisibleRowCount(Math.min(12, items.size()));
        this.list.addListSelectionListener(new ListOptionPaneListSelectionListener());
        JPanel south = new JPanel();
        this.ok = GuiUtils.createButton("OK", null, 'O', this);
        south.add(this.ok);
        this.cancel = GuiUtils.createButton("Cancel", null, 'C', this);
        south.add(this.cancel);
        this.add(new JScrollPane(this.list));
        this.add((Component)south, "South");
        this.pack();
        if (frame != null) {
            this.setLocation(frame.getX() + (frame.getWidth() - this.getWidth()) / 2, frame.getY() + (frame.getHeight() - this.getHeight()) / 2);
        } else {
            GuiUtils.centerWindow(this);
        }
        ListOptionPaneKeyListener keyListener = new ListOptionPaneKeyListener();
        this.addKeyListener(keyListener);
        this.ok.requestFocus();
        this.ok.addKeyListener(keyListener);
        this.cancel.addKeyListener(keyListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.ok) {
            this.pressedOk = true;
        } else if (src == this.cancel) {
            this.setVisible(false);
        }
        this.setVisible(false);
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public boolean hasSelectedValue() {
        return this.list.getSelectedIndex() >= 0;
    }

    public boolean pressedOk() {
        return this.pressedOk;
    }

    public void setMultipleSelection(boolean enabled) {
        if (enabled) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
    }

    private class ListOptionPaneKeyListener
    extends KeyAdapter {
        private ListOptionPaneKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 27) {
                ListOptionPane.this.setVisible(false);
            }
        }
    }

    private class ListOptionPaneListSelectionListener
    implements ListSelectionListener {
        private ListOptionPaneListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent arg0) {
            if (ListOptionPane.this.hasSelectedValue()) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ListOptionPane.this.pressedOk = true;
                        ListOptionPane.this.setVisible(false);
                    }
                }).start();
            }
        }
    }
}

