/*
 * CS 106B, Marty Stepp and Cynthia Lee
 *
 * This file provides the implementation of the bodies of the member functions,
 * constructor, and overloaded operators for the BankAccount class
 * that is declared in BankAccount.h.
 *
 * Invariant: balance >= 0.00
 */

#include "BankAccount.h"
#include "error.h"
#include <iomanip>         // for setprecision, fixed in << operator

BankAccount::BankAccount(string n) {
    name = n;
    balance = 0.0;
}

BankAccount::BankAccount(string name, double balance) {
    this->name = name;
    this->balance = balance;
    if (this->balance < 0) {
        error("Starting balance less than zero.");
    }
}

void BankAccount::withdraw(double amount) {
    if (balance - amount < 0) {
        error("You are out of funds! But still a good person.");
    } else if (amount < 0){
        error("Cannot withdraw negative amount.");
    } else {
        balance -= amount;
    }
}

double BankAccount::getBalance() const {
    return balance;
}

string BankAccount::getName() const {
    return name;
}

void BankAccount::deposit(double amount) {
    if (amount < 0){
        error("Cannot deposit negative amount.");
    } else {
        balance += amount;
    }
}

void BankAccount::transferTo(BankAccount& person, double amount) {
    if (amount < 0) {
        throw "Cannot transfer negative amount";
    }
    if (balance >= amount) {
        withdraw(amount);
        person.deposit(amount);
    }
}

void BankAccount::changeName(string name) {
    this->name = name;
}

bool operator ==(BankAccount& ba1, BankAccount& ba2) {
    return (ba1.getName() == ba2.getName() &&
            ba1.getBalance() == ba2.getBalance());
}

bool operator !=(BankAccount& ba1, BankAccount& ba2) {
    return !(ba1 == ba2);
}

ostream& operator <<(ostream& out, BankAccount& ba) {
    out << ba.getName()
         << ", $" << fixed << setprecision(2) << ba.getBalance();
    return out;
}
