/*
 * CS 106B, Marty Stepp 2015, updated Cynthia Lee 2016
 * This file declares a class named BankAccount.
 * Each BankAccount object represents information about a single
 * person's bank account, such as their name and balance.
 * Implementation of each class member is found in BankAccount.cpp.
 */

// Initial version of BankAccount.h.
// Uses public member variables and no functions.
// Not good style, but we will improve it.

#ifndef _bankaccount_h
#define _bankaccount_h

#include <iostream>
#include <string>
using namespace std;


class BankAccount {
public:
    BankAccount(string n);
    BankAccount(string n, double balance);
    double getBalance() const;
    string getName() const;
    void withdraw(double amt);
    void changeName(string name);
    void transferTo(BankAccount& person, double amount);
    void deposit(double amount);

private:
    string name;      // each BankAccount object
    double balance;   // has a name and balance
};

// overloaded operators for testing for equality and printing
bool operator ==(BankAccount& ba1, BankAccount& ba2);
bool operator !=(BankAccount& ba1, BankAccount& ba2);
ostream& operator <<(ostream& out, BankAccount& ba);

#endif
