/*
 * This file implements the members of the Lawyer class.
 * See Lawyer.h for declarations and more documentation.
 *  (c) Marty Stepp
 *  edits Cynthia Lee for CS106B
 */

#include "Lawyer.h"
#include <iostream>

Lawyer::Lawyer(string name, int years, string lawSchool)
    : Employee(name, years) {
    m_lawSchool = lawSchool;
}

double Lawyer::salary() const {
    // Return twice the equivalent regular employee salary
    return 2 * Employee::salary();
}

void Lawyer::sue(string person) {
    cout << "I'll see you in court, " << person
         << "!!!!! PS: Cease and desist etc." << endl;
}

string Lawyer::name() const {
    // Return name with Esq, ex: "Diane Roldan, Esq."
    return Employee::name() + ", Esq.";
}

string Lawyer::almaMater() const {
    return m_lawSchool;
}
