/*
 * This client program uses our classes built with inheritance.
 *  (c) Marty Stepp
 *  edits Cynthia Lee for CS106B
 */

#include <iostream>
#include <iomanip>
#include "console.h"
#include "vector.h"
#include "Employee.h"
#include "Programmer.h"
#include "Lawyer.h"
using namespace std;

void printEmployeeInfo(Employee* employee) {
    cout << "Employee information:" << endl;
    cout << "Name:          " << employee->name() << endl;
    cout << "Years:         " << employee->years() << endl;
    cout << "Salary:        $" << fixed << setprecision(2) << employee->salary() << endl;
    cout << "Vacation days: " << employee->vacationDays() << endl;
}

void doMonthlyPaycheck(Employee *employee) {
    cout << "You are now $" << employee->salary()/12 << " wealthier!" << endl;
}

int main() {
    Employee pedro("Pedro", 4);
    printEmployeeInfo(&pedro);
    cout << endl;

    Programmer cynthia("Cynthia", 2);
    printEmployeeInfo(&cynthia);
    cynthia.code("C++");
    cout << endl;

    Lawyer diane("Diane", 6, "Stanford");
    cout << diane.name() << " gets " << diane.vacationDays() << " vacation days." << endl;
    printEmployeeInfo(&diane);
    diane.sue("Cynthia");
    cout << endl;

    // Write code to handle payroll
    Vector<Employee*> allStaff;
    allStaff.add(&pedro);
    allStaff.add(&cynthia);
    allStaff.add(&diane);
    for (int i = 0; i < allStaff.size(); i++) {
        doMonthlyPaycheck(allStaff[i]);
    }
    
    return 0;
}
