/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import stanford.spl.Base64;
import stanford.spl.GInteractor;
import stanford.spl.SplPipeDecoder;

public class GBufferedImage
extends GInteractor {
    private static final long serialVersionUID = 1L;
    private BufferedImage bufferedImage;
    private int imageWidth;
    private int imageHeight;
    private int backgroundColor;
    private JLabel label;

    public GBufferedImage(int width, int height) {
        this(width, height, 0);
    }

    public GBufferedImage(int width, int height, int backgroundColor) {
        super(new JLabel("HOORAY"));
        this.imageWidth = width;
        this.imageHeight = height;
        this.backgroundColor = backgroundColor;
        this.bufferedImage = new BufferedImage(width, height, 1);
        this.label = (JLabel)this.getInteractor();
        if (backgroundColor != 0) {
            this.fill(backgroundColor);
        }
        this.repaintImage();
    }

    public void clear() {
        this.fill(this.backgroundColor);
    }

    public void fill(int rgb) {
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                this.bufferedImage.setRGB(x, y, rgb);
                ++x;
            }
            ++y;
        }
        this.repaintImage();
    }

    public void fillRegion(int x, int y, int width, int height, int rgb) {
        int yy = y;
        while (yy < y + height) {
            int xx = x;
            while (xx < x + width) {
                this.bufferedImage.setRGB(xx, yy, rgb);
                ++xx;
            }
            ++yy;
        }
        this.repaintImage();
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void load(String filename) {
        try {
            this.bufferedImage = ImageIO.read(new File(filename));
            this.imageWidth = this.bufferedImage.getWidth();
            this.imageHeight = this.bufferedImage.getHeight();
            this.repaintImage();
            SplPipeDecoder.writeResult(this.toStringBase64());
        }
        catch (Exception ex) {
            SplPipeDecoder.writeResult("error:" + ex.getClass().getSimpleName() + ": " + ex.getMessage().replace('\n', ' '));
        }
    }

    public void resize(int w, int h, boolean retain) {
        BufferedImage oldImage = this.bufferedImage;
        this.bufferedImage = new BufferedImage(w, h, 1);
        this.imageWidth = w;
        this.imageHeight = h;
        this.fill(this.backgroundColor);
        if (retain) {
            Graphics g = this.bufferedImage.getGraphics();
            g.drawImage(oldImage, 0, 0, this.label);
        }
        this.repaintImage();
    }

    public void save(String filename) {
        String extension = "png";
        int dot = filename.lastIndexOf(46);
        if (dot >= 0) {
            extension = filename.substring(dot + 1).toLowerCase();
        }
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, extension, new File(filename));
            SplPipeDecoder.writeResult("ok");
        }
        catch (Exception ex) {
            SplPipeDecoder.writeResult("error:" + ex.getClass().getSimpleName() + ": " + ex.getMessage().replace('\n', ' '));
        }
    }

    public void setRGB(int x, int y, int rgb) {
        this.bufferedImage.setRGB(x, y, rgb);
        this.repaintImage();
    }

    public String toStringBase64() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.imageWidth * this.imageHeight * 3 + 512);
        out.write((this.imageWidth & 0xFF00) >> 8 & 0xFF);
        out.write(this.imageWidth & 0xFF);
        out.write((this.imageHeight & 0xFF00) >> 8 & 0xFF);
        out.write(this.imageHeight & 0xFF);
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                int px = this.bufferedImage.getRGB(x, y);
                int red = (px & 0xFF0000) >> 16;
                int green = (px & 0xFF00) >> 8;
                int blue = px & 0xFF;
                out.write(red);
                out.write(green);
                out.write(blue);
                ++x;
            }
            ++y;
        }
        String base64 = Base64.encodeBytes(out.toByteArray());
        return base64;
    }

    public String toStringCompressed() {
        StringBuilder sb = new StringBuilder(this.imageWidth * this.imageHeight * 7 + 32);
        sb.append(this.imageWidth);
        sb.append('#');
        sb.append(this.imageHeight);
        sb.append('#');
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                int px = this.bufferedImage.getRGB(x, y);
                sb.append(String.format("#%06x", px & 0xFFFFFF));
                ++x;
            }
            ++y;
        }
        return sb.toString();
    }

    public void fromStringBase64(String base64) throws IOException {
        byte[] bytes = Base64.decode(base64);
        int w = (bytes[0] & 0xFF) << 8 & 0xFF00 | bytes[1] & 0xFF;
        int h = (bytes[2] & 0xFF) << 8 & 0xFF00 | bytes[3] & 0xFF;
        if (w != this.imageWidth || h != this.imageHeight) {
            this.resize(w, h, false);
        }
        int[] pixelArray = new int[w * h];
        int byteIndex = 4;
        int index = 0;
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                int rgb;
                pixelArray[index] = rgb = 0xFF000000 | bytes[byteIndex] << 16 & 0xFF0000 | bytes[byteIndex + 1] << 8 & 0xFF00 | bytes[byteIndex + 2] & 0xFF;
                ++index;
                byteIndex += 3;
                ++x;
            }
            ++y;
        }
        this.bufferedImage.setRGB(0, 0, w, h, pixelArray, 0, w);
        this.repaintImage();
    }

    public void fromStringCompressed(String data) throws IOException {
        int ch;
        BufferedReader reader = new BufferedReader(new StringReader(data));
        int w = 0;
        while ((ch = reader.read()) != 35) {
            w = 10 * w + (ch - 48);
        }
        int h = 0;
        while ((ch = reader.read()) != 35) {
            h = 10 * h + (ch - 48);
        }
        if (w != this.imageWidth || h != this.imageHeight) {
            this.resize(w, h, true);
        }
        int[] pixelArray = new int[w * h];
        int index = 0;
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                reader.read();
                int rgb = 0;
                int i = 0;
                while (i < 6) {
                    int oneByte = reader.read();
                    oneByte = oneByte >= 48 && oneByte <= 57 ? oneByte - 48 : oneByte - 97 + 10;
                    rgb = rgb << 4 | oneByte;
                    ++i;
                }
                pixelArray[index] = rgb;
                ++index;
                ++x;
            }
            ++y;
        }
        reader.close();
        this.bufferedImage.setRGB(0, 0, w, h, pixelArray, 0, w);
        this.repaintImage();
    }

    private void repaintImage() {
        Dimension oldSize = this.label.getPreferredSize();
        this.label.setIcon(new ImageIcon(this.bufferedImage));
        Dimension size = new Dimension(this.imageWidth, this.imageHeight);
        if (!size.equals(oldSize)) {
            this.label.setPreferredSize(size);
            this.label.setSize(size);
        }
    }
}

