/**
 * File: password-guesser.cpp
 * ---------------------------
 * A first look at combining loops with recursion to generate
 * permutations.
 *
 * (c) Cynthia Lee 2015
 *
 */

#include <iostream>
#include <fstream>
using namespace std;

#include "simpio.h"
#include "gwindow.h"
#include "filelib.h"


/* Function Prototypes */
static void generatePasswords(int length, string currentPassword, ostream &outfile);


/* 
 * Generate all passwords of the letters a-z of length N
 * Write them to a file
 */
int main() {
    setConsoleFont("Arial-18");
    while (true){
        int length = getInteger("Number of characters in password (0 to quit): ");
        if (length <= 0) break;
        ofstream outfile;
        promptUserForFile(outfile, "Enter filename: ");
        string password;
        generatePasswords(length, password, cout);
    }
    return 0;
}

static void generatePasswords(int length, string currentPassword, ostream &outfile) {
    if (currentPassword.length() == length) {
        outfile << currentPassword << endl;
        return;
    }

    for (char ch = 'a'; ch <= 'd'; ch++) {
        string newPassword = currentPassword;
        newPassword += ch;
        generatePasswords(length, newPassword, outfile);
    }
}

