/* ************************************************************
 *
 * Compound Collections & Returning a Reference
 *
 * example.cpp
 *
 * Cynthia Lee (c) 2014
 *
 * These are a few examples showing how compound collections
 * work and how they behave when they return a copy of their
 * data vs return a reference to their data. These examples
 * are the same/similar as a few we did in in-class discussion
 * questions.
 *
 * ************************************************************/
#include "simpio.h"
#include "map.h"
#include "vector.h"
#include "console.h"
#include "gwindow.h" // for pause()

using namespace std;

int main() {

    setConsoleFont("Arial-18");

    Map<string,Vector<int>> mymap;
    Vector<int> numbers;
    numbers.add(1);
    numbers.add(2);
    numbers.add(3);
    mymap["123"] = numbers;
    cout << "Initial size of vector should be 3: " << mymap["123"].size() << endl << endl;

    getLine();

    // TEST 1
    mymap["123"].add(6);
    cout << "We added an element to vector as part of [] expression." << endl;
    cout << "Size of vector in map is... " << flush;
    pause(500);
    cout << mymap["123"].size() << endl << endl;

    getLine();

    // TEST 2
    Vector<int> plainTest = mymap["123"];
    plainTest.add(4);
    cout << "We added an element to returned vector." << endl;
    cout << "Size of vector in map is... "  << flush;
    pause(500);
    cout << mymap["123"].size() << endl << endl;

    getLine();

    // TEST 3
    Vector<int>& referenceTest = mymap["123"];
    referenceTest.add(5);
    cout << "We added an element to *reference* returned vector." << endl;
    cout << "Size of vector in map is... " << flush;
    pause(500);
    cout << mymap["123"].size() << endl << endl;

    getLine();

    // TEST 4
    Map<string,string> stringmap;
    cout << "Initial size of map should be 0: " << stringmap.size() << endl;
    pause(500);
    if (stringmap["tentative"] == "") cout << "\"tentative\" is not in the map." << endl << endl;
    else cout << "\"tentative\" is in the map." << endl << endl;
    pause(500);
    cout << "We tested if \"tentative\" is an element of the map." << endl;
    cout << "Size of vector in map is now... " << flush;
    pause(500);
    cout << stringmap.size() << endl << endl;

    getLine();

    return 0;
}
