/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.gui.WindowCloseKeyListener;
import stanford.cs106.util.StringUtils;
import stanford.spl.SPLWindowSettings;

public class TextFileDialog
extends JDialog {
    public static final int DEFAULT_ROWS = 20;
    public static final int DEFAULT_COLUMNS = 80;
    public static final int MIN_ROWS = 5;
    public static final int MIN_COLUMNS = 40;
    public static final int MAX_ROWS = 50;
    public static final int MAX_COLUMNS = 100;
    private JTextArea textarea;
    private JScrollPane scrollPane;

    public TextFileDialog(Window parent) {
        super(parent);
    }

    public void addText(String text) {
        this.textarea.setText(String.valueOf(this.textarea.getText()) + text);
        JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    public void clearText() {
        this.textarea.setText("");
    }

    public void print(String text) {
        this.addText(text);
    }

    public void println(String text) {
        this.addText(String.valueOf(text) + "\n");
    }

    public void println(Object o) {
        this.println(String.valueOf(o));
    }

    public static TextFileDialog showDialog(Component parent, String title) {
        return TextFileDialog.showDialog(parent, title, "");
    }

    public static TextFileDialog showDialog(Component parent, String title, boolean modal) {
        return TextFileDialog.showDialog(parent, title, "", 20, 80, modal);
    }

    public static TextFileDialog showDialog(Component parent, String title, String text) {
        return TextFileDialog.showDialog(parent, title, text, 20, 80, true);
    }

    public static TextFileDialog showDialog(Component parent, String title, String text, boolean modal) {
        return TextFileDialog.showDialog(parent, title, text, 20, 80, modal);
    }

    public static TextFileDialog showDialog(Component parent, String title, String text, int rows, int cols) {
        return TextFileDialog.showDialog(parent, title, text, rows, cols, true);
    }

    public static TextFileDialog showDialog(Component parent, String title, String text, int rows, int cols, boolean modal) {
        if (rows <= 0) {
            rows = 20;
        }
        if (cols <= 0) {
            cols = 80;
        }
        int height = StringUtils.getHeight(text);
        int width = StringUtils.getWidth(text);
        height = Math.max(5, Math.min(50, height));
        width = Math.max(40, Math.min(100, width));
        TextFileDialog dialog = new TextFileDialog(parent instanceof Window ? (Window)parent : null);
        dialog.setTitle(title);
        dialog.setModal(modal);
        dialog.setDefaultCloseOperation(2);
        dialog.textarea = new JTextArea(text, height, width);
        dialog.textarea.setEditable(false);
        Font oldFont = dialog.textarea.getFont();
        dialog.textarea.setFont(new Font("Monospaced", 0, oldFont.getSize()));
        dialog.scrollPane = new JScrollPane(dialog.textarea);
        dialog.add((Component)dialog.scrollPane, "Center");
        JPanel south = new JPanel();
        JButton ok = new JButton("OK");
        ok.setIcon(GuiUtils.extractOptionPaneIcon("OK"));
        ok.setMnemonic('O');
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TextFileDialog.this.setVisible(false);
                TextFileDialog.this.dispose();
            }
        });
        south.add(ok);
        dialog.add((Component)south, "South");
        new WindowCloseKeyListener(dialog);
        dialog.pack();
        SPLWindowSettings.loadWindowLocation(dialog);
        SPLWindowSettings.saveWindowLocation(dialog);
        ok.requestFocus();
        dialog.setVisible(true);
        return dialog;
    }
}

