/* *********************************************************
 * Write a program to count the number of occurrences of
 * each unique word in a text file and make certain reports.
 *
 * (1) TOP WORDS REPORT: Report all words that appeared in
 * the book at least 10 times, in alphabetical order.
 *
 * (2) QUERY MODE: Allow the user to type a word and report
 * how many times that word appeared in the book. Repeat.
 *
 * Cynthia Lee 2014
 * CS106B
 ***********************************************************/

#include "console.h"
#include "map.h"
#include "simpio.h"
#include "filelib.h"
using namespace std;
#include <iostream>
#include <fstream>

static void countWords(ifstream& infile, Map<string, int>& wordCounts);
static void topWordsReport(const Map<string, int>& wordCounts);
static void wordQueryMode(const Map<string, int>& wordCounts);

static const int TOP_WORDS_CUTOFF = 10;

int main() {
    ifstream infile;
    Map<string,int> wordCounts;
    promptUserForFile(infile, "Enter filename (e.g. hurston.txt): ");
    countWords(infile, wordCounts);
    topWordsReport(wordCounts);
    wordQueryMode(wordCounts);
    return 0;
}


// Write a program to count the number of occurrences of
// each unique word in a text file
static void countWords(ifstream& infile, Map<string, int>& wordCounts) {
    string word;
    infile >> word;
    while (!infile.fail()) {
        wordCounts[word]++;
        infile >> word;
    }
}

// Report all words that appeared in the book at least TOP_WORDS_CUTOFF
// times, in alphabetical order
static void topWordsReport(const Map<string, int>& wordCounts) {
    cout << "Report of most common words:" << endl;
    for (string word : wordCounts) {
        int count = wordCounts[word];
                if (count >= 10) {
                cout << word << ":\t" << count << endl;
    }
    }
}


// Allow the user to type a word and report how many
// times that word appeared in the book
static void wordQueryMode(const Map<string, int>& wordCounts) {

    while (true) {
        string word = getLine("Enter a word: ");
        if (word == "") break;
        int count = 0;
        if (wordCounts.containsKey(word)) {
            count = wordCounts[word];
        }
        cout << "It occurs " << count << " times!" << endl;

    }
}

