/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class UrlDownloader {
    private static final UrlDownloader instance = new UrlDownloader();

    private UrlDownloader() {
    }

    public static UrlDownloader getInstance() {
        return instance;
    }

    public String download(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int result = connection.getResponseCode();
        if (result == 200) {
            InputStream stream = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder(65536);
            while (reader.ready()) {
                sb.append((char)reader.read());
            }
            reader.close();
            return sb.toString();
        }
        throw new ConnectException("Cannot connect to " + urlString + " (HTTP error " + result + ")");
    }

    public void download(String urlString, File file) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int result = connection.getResponseCode();
        if (result != 200) {
            throw new ConnectException("Cannot connect to " + urlString + " (HTTP error " + result + ")");
        }
        InputStream stream = url.openStream();
        ReadableByteChannel rbc = Channels.newChannel(stream);
        FileOutputStream fos = new FileOutputStream(file);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
    }
}

