/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;

public class GArc
extends GObject
implements GFillable {
    public static final double ARC_TOLERANCE = 2.5;
    private double frameWidth;
    private double frameHeight;
    private double arcStart;
    private double arcSweep;
    private Color fillColor;
    private boolean isFilled;
    static final long serialVersionUID = 21L;

    public GArc(double d, double d2, double d3, double d4) {
        this(0.0, 0.0, d, d2, d3, d4);
    }

    public GArc(double d, double d2, double d3, double d4, double d5, double d6) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.arcStart = d5;
        this.arcSweep = d6;
        this.setLocation(d, d2);
    }

    public void setStartAngle(double d) {
        this.arcStart = d;
        this.repaint();
    }

    public double getStartAngle() {
        return this.arcStart;
    }

    public void setSweepAngle(double d) {
        this.arcSweep = d;
        this.repaint();
    }

    public double getSweepAngle() {
        return this.arcSweep;
    }

    public GPoint getStartPoint() {
        return this.getArcPoint(this.arcStart);
    }

    public GPoint getEndPoint() {
        return this.getArcPoint(this.arcStart + this.arcSweep);
    }

    protected void paint2d(Graphics2D graphics2D) {
        Arc2D.Double double_ = new Arc2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight, this.arcStart, this.arcSweep, this.isFilled() ? 2 : 0);
        if (this.isFilled()) {
            graphics2D.setColor(this.getFillColor());
            graphics2D.fill(double_);
            graphics2D.setColor(this.getColor());
        }
        graphics2D.draw(double_);
    }

    public GRectangle getBounds() {
        double d = this.frameWidth / 2.0;
        double d2 = this.frameHeight / 2.0;
        double d3 = this.getX() + d;
        double d4 = this.getY() + d2;
        double d5 = d3 + GMath.cosDegrees(this.arcStart) * d;
        double d6 = d4 - GMath.sinDegrees(this.arcStart) * d2;
        double d7 = d3 + GMath.cosDegrees(this.arcStart + this.arcSweep) * d;
        double d8 = d4 - GMath.sinDegrees(this.arcStart + this.arcSweep) * d2;
        double d9 = Math.min(d5, d7);
        double d10 = Math.max(d5, d7);
        double d11 = Math.min(d6, d8);
        double d12 = Math.max(d6, d8);
        if (this.containsAngle(0.0)) {
            d10 = d3 + d;
        }
        if (this.containsAngle(90.0)) {
            d11 = d4 - d2;
        }
        if (this.containsAngle(180.0)) {
            d9 = d3 - d;
        }
        if (this.containsAngle(270.0)) {
            d12 = d4 + d2;
        }
        if (this.isFilled()) {
            d9 = Math.min(d9, d3);
            d11 = Math.min(d11, d4);
            d10 = Math.max(d10, d3);
            d12 = Math.max(d12, d4);
        }
        return new GRectangle(d9, d11, d10 - d9, d12 - d11);
    }

    public boolean contains(double d, double d2) {
        double d3 = this.frameWidth / 2.0;
        double d4 = this.frameHeight / 2.0;
        if (d3 == 0.0 || d4 == 0.0) {
            return false;
        }
        double d5 = d - (this.getX() + d3);
        double d6 = d2 - (this.getY() + d4);
        double d7 = d5 * d5 / (d3 * d3) + d6 * d6 / (d4 * d4);
        if (this.isFilled()) {
            if (d7 > 1.0) {
                return false;
            }
        } else {
            double d8 = 2.5 / ((d3 + d4) / 2.0);
            if (Math.abs(1.0 - d7) > d8) {
                return false;
            }
        }
        return this.containsAngle(GMath.toDegrees(Math.atan2(-d6, d5)));
    }

    public void setFrameRectangle(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public final void setFrameRectangle(GRectangle gRectangle) {
        this.setFrameRectangle(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public GRectangle getFrameRectangle() {
        return new GRectangle(this.getX(), this.getY(), this.frameWidth, this.frameHeight);
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public String paramString() {
        String string = super.paramString();
        string = string.substring(string.indexOf(41) + 1);
        GRectangle gRectangle = this.getFrameRectangle();
        String string2 = "frame=(" + gRectangle.getX() + ", " + gRectangle.getY() + ", " + gRectangle.getWidth() + ", " + gRectangle.getHeight() + ")";
        string2 = string2 + ", start=" + this.arcStart + ", sweep=" + this.arcSweep;
        return string2 + string;
    }

    private GPoint getArcPoint(double d) {
        double d2 = this.frameWidth / 2.0;
        double d3 = this.frameHeight / 2.0;
        double d4 = this.getX() + d2;
        double d5 = this.getY() + d3;
        return new GPoint(d4 + d2 * GMath.cosDegrees(d), d5 - d3 * GMath.sinDegrees(d));
    }

    private boolean containsAngle(double d) {
        double d2 = Math.min(this.getStartAngle(), this.getStartAngle() + this.getSweepAngle());
        double d3 = Math.abs(this.getSweepAngle());
        if (d3 >= 360.0) {
            return true;
        }
        d = d < 0.0 ? 360.0 - -d % 360.0 : d % 360.0;
        double d4 = d2 = d2 < 0.0 ? 360.0 - -d2 % 360.0 : d2 % 360.0;
        if (d2 + d3 > 360.0) {
            return d >= d2 || d <= d2 + d3 - 360.0;
        }
        return d >= d2 && d <= d2 + d3;
    }
}

