/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;

public class IntField
extends JTextField {
    private static final int MINIMUM_WIDTH = 60;
    private static final int MINIMUM_HEIGHT = 22;
    private static final int PIXEL_MARGIN = 2;
    private boolean exceptionOnError;
    private int minValue;
    private int maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private NumberFormat parser = NumberFormat.getNumberInstance(Locale.US);
    private IODialog dialog;
    static final long serialVersionUID = 1L;

    public IntField() {
        this("", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int n) {
        this("" + n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int n, int n2) {
        this("", n, n2);
    }

    public IntField(int n, int n2, int n3) {
        this("" + n, n2, n3);
    }

    private IntField(String string, int n, int n2) {
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(4);
        this.minValue = n;
        this.maxValue = n2;
        this.setText(string);
        this.exceptionOnError = false;
    }

    public int getValue() {
        int n;
        block9: {
            String string = this.getText().trim();
            if (string.length() == 0) {
                if (this.minValue <= 0 && this.maxValue >= 0) {
                    return 0;
                }
                return this.minValue;
            }
            String string2 = null;
            n = 0;
            try {
                n = this.parser.parse(string).intValue();
                if (n >= this.minValue && n <= this.maxValue) break block9;
                string2 = "Value is outside the specified range";
            }
            catch (ParseException parseException) {
                string2 = "Illegal integer format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(string2);
            }
            String string3 = "Enter an integer";
            if (this.minValue != Integer.MIN_VALUE) {
                string3 = this.maxValue != Integer.MAX_VALUE ? string3 + " between " + this.minValue + " and " + this.maxValue : string3 + " greater than " + this.minValue;
            } else if (this.maxValue != Integer.MAX_VALUE) {
                string3 = string3 + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            n = this.dialog.readInt(string3, this.minValue, this.maxValue);
        }
        this.setValue(n);
        return n;
    }

    public void setValue(int n) {
        this.setText(this.formatter == null ? this.defaultFormat(n) : this.formatter.format(n));
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String string) {
        String string2 = this.getText().trim();
        int n = 0;
        if (string2.length() != 0) {
            try {
                n = this.parser.parse(string2).intValue();
            }
            catch (ParseException parseException) {
                throw new ErrorException(parseException);
            }
        }
        this.formatString = string;
        if (string == null) {
            this.formatter = null;
            this.parser = NumberFormat.getNumberInstance(Locale.US);
        } else {
            this.formatter = string.length() == 0 ? new DecimalFormat() : new DecimalFormat(string);
            this.parser = this.formatter;
        }
        if (string2.length() != 0) {
            this.setValue(n);
        }
    }

    public void setExceptionOnError(boolean bl) {
        this.exceptionOnError = bl;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(60, dimension.width), Math.max(22, dimension.height));
    }

    private String defaultFormat(int n) {
        String string = "" + n;
        int n2 = this.getSize().width - 4;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics.stringWidth(string) > n2) {
            string = "";
            while (fontMetrics.stringWidth(string + "#") <= n2) {
                string = string + "#";
            }
        }
        return string;
    }
}

