/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.Program;
import acm.util.JTFTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class AppletStarter
implements Runnable {
    private Program myProgram;
    private Thread mainThread;
    private Object executor;

    public AppletStarter(Program program) {
        this.myProgram = program;
    }

    public void start() {
        try {
            this.mainThread = new Thread(this);
            this.mainThread.start();
            if (JTFTools.testDebugOption("startup")) {
                System.out.println("Starting main thread using Thread package");
            }
        }
        catch (SecurityException ex) {
            if (JTFTools.testDebugOption("startup")) {
                System.out.println("Starting main thread using Executor because " + ex);
            }
            this.forkUsingExecutor();
        }
    }

    public void stop() {
        try {
            if (this.executor == null) {
                Class<?> threadClass = Class.forName("java.lang.Thread");
                Method stop = threadClass.getMethod("stop", new Class[0]);
                stop.invoke((Object)this.mainThread, new Object[0]);
            } else {
                Method shutdownNow = this.executor.getClass().getMethod("shutdownNow", new Class[0]);
                shutdownNow.invoke(this.executor, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.myProgram.startRun();
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    private void forkUsingExecutor() {
        try {
            Class<?> scheduledExecutorClass = Class.forName("java.util.concurrent.ScheduledExecutor");
            Class[] types1 = new Class[]{Integer.TYPE};
            Object[] args1 = new Object[]{new Integer(1)};
            Constructor<?> constructor = scheduledExecutorClass.getConstructor(types1);
            this.executor = constructor.newInstance(args1);
            Class<?> timeUnitClass = Class.forName("java.util.concurrent.TimeUnit");
            Field secondsField = timeUnitClass.getField("SECONDS");
            Object seconds = secondsField.get(null);
            Class[] types2 = new Class[]{Class.forName("java.lang.Runnable"), Long.TYPE, Class.forName("java.util.concurrent.TimeUnit")};
            Object[] args2 = new Object[]{this, new Long(0L), seconds};
            Method schedule = this.executor.getClass().getMethod("schedule", types2);
            schedule.invoke(this.executor, args2);
        }
        catch (Exception ex) {
            if (JTFTools.testDebugOption("startup")) {
                System.out.println("Executor failed because " + ex);
            }
            this.executor = null;
            this.mainThread = Thread.currentThread();
            this.myProgram.startRun();
        }
    }
}

