/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import stanford.spl.GInteractor;

public class GBufferedImage
extends GInteractor {
    private static final long serialVersionUID = 1L;
    private BufferedImage bufferedImage;
    private int imageWidth;
    private int imageHeight;
    private JLabel label;

    public GBufferedImage(int width, int height) {
        super(new JLabel("HOORAY"));
        this.imageWidth = width;
        this.imageHeight = height;
        this.bufferedImage = new BufferedImage(width, height, 1);
        this.label = (JLabel)this.getInteractor();
        this.repaintImage();
    }

    public void fill(int rgb) {
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                this.bufferedImage.setRGB(x, y, rgb);
                ++x;
            }
            ++y;
        }
        this.repaintImage();
    }

    public void fillRegion(int x, int y, int width, int height, int rgb) {
        int yy = y;
        while (yy < y + height) {
            int xx = x;
            while (xx < x + width) {
                this.bufferedImage.setRGB(xx, yy, rgb);
                ++xx;
            }
            ++yy;
        }
        this.repaintImage();
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setRGB(int x, int y, int rgb) {
        this.bufferedImage.setRGB(x, y, rgb);
        this.repaintImage();
    }

    private void repaintImage() {
        this.label.setIcon(new ImageIcon(this.bufferedImage));
        Dimension size = new Dimension(this.imageWidth, this.imageHeight);
        this.label.setPreferredSize(size);
        this.label.setSize(size);
    }
}

