/*
 * CS 106B/X, Marty Stepp
 * This file contains several recursive function examples.
 * A recursive function is one that calls itself.
 * A recursive call often handles a small part of the overall problem,
 * leaving the rest to be handled by other self-calls.
 */

#include <cctype>
#include <fstream>
#include <iostream>
#include "console.h"
#include "recursion.h"
#include "strlib.h"
using namespace std;

// function prototype declarations
int evaluate(string expression);

void test_evaluate(const string& expression, int expected);


int main_rec() {
    // test the evaluate function
    cout << "evaluate tests:" << endl;
    test_evaluate("(1+(2*4))", 9);
    test_evaluate("((1+1)*(2*(3+3)))", 24);
    test_evaluate("((1+3)*(2*(4+1)))", 40);
    test_evaluate("((1+3)+((1+2)*5))", 19);

    return 0;
}

int evaluateHelper(string exp, int& index);

/*
 * Evaluates mathematical expressions that use addition and multiplication.
 * Assumes:
 * - expression is "fully parenthesized"
 * - expression format is valid
 * - all numbers in expression are single-digit non-negative integers
 *
 * Examples:
 * "7"                  => 7
 * "(2+2)"              => 4
 *      ^
 * "(1+(2*4))"          => 9
 * "((1+3)+((1+2)*5))"  => 19
 */
int evaluate(string exp) {
    int index = 0;
    return evaluateHelper(exp, index);
}

// recursive helper to implement evaluate behavior
int evaluateHelper(string exp, int& index) {
    char ch = exp[index];
    if (ch == '(') {
        // complex
        index++;   // move past ( character
        int left = evaluateHelper(exp, index);   // 2
        char opr = exp[index];                   // '+'
        index++;
        int right = evaluateHelper(exp, index);  // 2
        index++;   // move past ) character
        if (opr == '+') {
            return left + right;
        } else {
            return left * right;
        }
    } else {
        // simple -   '7' => return 7
        index++;
        return charToInteger(ch);
    }
}






// =================== testing code below =================== //

// Tests whether or not the given expression evaluates to the given input
// and tests the result.
void test_evaluate(const string& expression, int expected) {
    int result = evaluate(expression);
    cout << "evaluate(" << expression << ") returned " <<  result << " ";
    cout << (result == expected ? "PASSED" : "FAILED") << endl;
}
