/*
 * CS 106B/X, Marty Stepp
 * This instructor-provided file contains the implementation of the Board class,
 * used in the 8 Queens example.  We didn't write this code in class.
 * See Board.h for documentation of each member.
 */

#include "Board.h"
#include <sstream>
#include "console.h"
#include "strlib.h"
#include "gwindow.h"
using namespace std;

Board::Board(int size) {
    if (size < 1) {
        throw size;
    }
    m_size = size;
    m_delayMS = 0;
    m_board = new bool*[m_size]();
    for (int i = 0; i < m_size; i++) {
        m_board[i] = new bool[m_size]();
    }
}

Board::~Board() {
    for (int i = 0; i < m_size; i++) {
        delete[] m_board[i];
    }
    delete[] m_board;
}

bool Board::inBounds(int row, int col) const {
    return row >= 0 && row < m_size && col >= 0 && col < m_size;
}

bool Board::isOnBoard(int row, int col) const {
    return row >= 0 && row < m_size && col >= 0 && col < m_size;
}

bool Board::isSafe(int row, int col, bool existing) const {
    checkIndex(row, col);
    
    // check row (horizontal sweep)
    for (int r = 0; r < m_size; r++) {
        if (m_board[r][col]) {
            if (!existing || r != row) {
                return false;
            }
        }
    }
    
    // check column (vertical sweep)
    for (int c = 0; c < m_size; c++) {
        if (m_board[row][c]) {
            if (!existing || c != col) {
                return false;
            }
        }
    }
    
    // check diagonals
    for (int delta = existing ? 1 : 0; delta < m_size; delta++) {
        if ((isOnBoard(row - delta, col - delta) && m_board[row - delta][col - delta])
         || (isOnBoard(row - delta, col + delta) && m_board[row - delta][col + delta])
         || (isOnBoard(row + delta, col - delta) && m_board[row + delta][col - delta])
         || (isOnBoard(row + delta, col + delta) && m_board[row + delta][col + delta])) {
            return false;
        }
    }
    
    return true;
}

bool Board::isValid() const {
    for (int r = 0; r < m_size; r++) {
        for (int c = 0; c < m_size; c++) {
            // check if an existing placed queen is in a non-safe place
            if (m_board[r][c] && !isSafe(r, c, /* existing */ true)) {
                return false;
            }
        }
    }
    return true;
}

void Board::place(int row, int col) {
    checkIndex(row, col);
    checkDelay();
    m_board[row][col] = true;
}

void Board::remove(int row, int col) {
    checkIndex(row, col);
    checkDelay();
    m_board[row][col] = false;
}

void Board::setDelay(int ms) {
    m_delayMS = ms;
}

int Board::size() const {
    return m_size;
}

string Board::toString() const {
    ostringstream out;
    for (int r = 0; r < m_size; r++) {
        for (int c = 0; c < m_size; c++) {
            out << (m_board[r][c] ? "Q " : "- ");
        }
        out << endl;
    }
    return out.str();
}

void Board::checkDelay() const {
    if (m_delayMS > 0) {
        clearConsole();
        cout << "===============" << endl;
        cout << this->toString();
        cout << "===============" << endl;
        pause(m_delayMS);
    }
}

void Board::checkIndex(int row, int col) const {
    if (!isOnBoard(row, col)) {
        throw "illegal index: row=" + integerToString(row) + ", col=" + integerToString(col);
    }
}

ostream& operator <<(ostream& out, const Board& board) {
    out << board.toString();
    return out;
}
