/*
 * CS 106B/X, Marty Stepp
 * This instructor-provided file contains the declaration of the Board class,
 * used in the 8 Queens example.  We didn't write this code in class.
 */

#ifndef _board_h
#define _board_h

#include <iostream>
#include <string>
using namespace std;

class Board {
public:
    /*
     * Constructs a board of the given size (rows x columns).
     * Throws an integer exception if the size is less than 1.
     */
    Board(int size);

    /*
     * Frees memory that was dynamically allocated by the board.
     */
    ~Board();

    /*
     * Returns true if the given row/col pair is in the range of
     * (0, 0) through (size-1, size-1).
     */
    bool inBounds(int row, int col) const;
    bool isOnBoard(int row, int col) const;

    /*
     * Returns true if it is safe to place a queen at the given row/column
     * position, meaning that no other existing queens can capture it.
     * If the optional parameter 'existing' is true, it means that you're checking
     * whether an existing queen is placed in a 'safe' place; if false, it means
     * that you're asking whether it would be safe to place a new queen in a blank square.
     * Throws a string exception if the row or column is out of bounds of the board.
     */
    bool isSafe(int row, int col, bool existing = false) const;

    /*
     * Returns true if the current board state is valid; that is, if all queens
     * currently on the board are unable to attack each other.
     * Returns true if there are no queens on the board.
     */
    bool isValid() const;

    /*
     * Places a queen at the given row/col position.
     * Does not check whether it is safe to do so; call isSafe or isValid for that.
     * Throws a string exception if the row or column is out of bounds of the board.
     */
    void place(int row, int col);

    /*
     * Un-places a queen from the given row/col position.
     * If there wasn't a queen there, has no effect.
     * Throws a string exception if the row or column is out of bounds of the board.
     */
    void remove(int row, int col);

    /*
     * Sets the board to have an animation delay of the given number of milliseconds.
     * If the value passed is greater than 0, prints the board and pauses that
     * many milliseconds after any call to place or remove is made.
     * The default initial state of the board is to have a delay of 0 ms.
     */
    void setDelay(int ms);

    /*
     * Returns the board's size, its number of rows and columns.
     * A default chess board would have 8 rows and columns.
     */
    int size() const;

    /*
     * Returns a 2-dimensional string representation of the board.
     * Squares in which a queen has been placed have a "Q" in them,
     * while empty squares have a dash "-" in them.
     */
    string toString() const;

private:
    int m_size;         // number of rows/cols
    bool** m_board;     // 2D array of board squares  (true=queen, false=empty)
    int m_delayMS;      // delay for animation (default 0=no animation)
    void checkDelay() const;   // checks and animates if necessary
    void checkIndex(int row, int col) const;   // throws an exception if row/col out of bounds
};

ostream& operator <<(ostream& out, const Board& board);

#endif
