/*
 * CS 106B/X, Marty Stepp
 *
 * This file is a client that uses our binary tree.
 */

#include <iomanip>
#include <iostream>
#include "console.h"
#include "treenode.h"

using namespace std;

/*
 * Prints all nodes of the tree with the given node as its root.
 */
void print(TreeNode* node) {
    if (node != nullptr) {
        // recursive case; might have
        // left and/or right subtrees
        // cout << node->left->data;
        print(node->left);
        cout << node->data << " ";
        print(node->right);
    } // else, empty, do nothing
}

/*
 * Returns the number of nodes in the given tree.
 */
int size(TreeNode* node) {
    if (node == nullptr) {
        return 0;
    } else {
        return 1 + size(node->left) + size(node->right);
    }
}

/*
 * Returns true if the given tree contains the given value.
 */
bool contains(TreeNode* node, int value) {
    return false;
}

/*
 * Returns the given tree's height.
 * The height of an empty tree is defined to be 0.
 * An unempty tree's height is the length of the longest path from the root
 * node to any other node in the tree.
 */
int height(TreeNode* node) {
    // TODO
    return 0;
}


/*
 * Adds the given element to this BST, if not already present.
 * If already present, has no effect.
 * Assumes tree is in valid BST order.
 * Notice that the given node pointer is passed by reference so that
 * we can change it and the change will modify the original tree.
 * O(log N)
 */
void add(TreeNode* &node, int value) {

}

/*
 * Returns the minimum value in this BST.
 * Assumes tree is in valid BST order and non-empty.
 * O(log N)
 */
int getMin(TreeNode* node) {
    if (node->left == nullptr) {
        return node->data;
    }
    return getMin(node->left);
}

/*
 * Returns the maximum value in this BST.
 * Assumes tree is in valid BST order and non-empty.
 * If tree is empty, returns 0;
 * O(log N)
 */
int getMax(TreeNode* node) {
    // TODO
    return 0;
}

/*
 * Removes the given element from this BST, if present.
 * If not present, has no effect.
 * Assumes tree is in valid BST order.
 * O(log N)
 */
void remove(TreeNode* node, int value) {

}

bool isBST(TreeNode* node) {
   //TODO
    return false;
}


///////////////////////////////////////////////////////////////////////////////
// END TREE FUNCTIONS
///////////////////////////////////////////////////////////////////////////////

int main() {
    /*
             55
           /     \
         29       87
       /   \    /   \
      -3  42   60   91
     */

    // create an initial tree
//    TreeNode* root = new TreeNode(55);
//    root->left = new TreeNode(29);
//    root->right = new TreeNode(87);
//    root->left->left = new TreeNode(-3);
//    root->left->right = new TreeNode(42);
//    root->right->left = new TreeNode(60);
//    root->right->right = new TreeNode(91);

//    // test the add function
    TreeNode* root = nullptr;
    add(root, 55);
    add(root, 29);
    add(root, 87);
    add(root, -3);
    add(root, 42);
    add(root, 60);
    add(root, 91);
    add(root, 49);

//    // call various functions on the tree
//    cout << "print:" << endl;
//    print(root);
//    cout << endl;
//    cout << "getMin:" << endl;
//    cout << getMin(root) << endl;

//    // test the contains function
//    cout << "contains 87: " << boolalpha << contains(root, 87) << endl;   // true
//    cout << "contains 42: " << boolalpha << contains(root, 42) << endl;   // true
//    cout << "contains 55: " << boolalpha << contains(root, 55) << endl;   // true
//    cout << "contains -3: " << boolalpha << contains(root, -3) << endl;   // true
//    cout << "contains 17: " << boolalpha << contains(root, 17) << endl;   // false
//    cout << "contains  6: " << boolalpha << contains(root, 6)  << endl;   // false
//    cout << "contains -1: " << boolalpha << contains(root, -1) << endl;   // false
//    cout << "contains  0: " << boolalpha << contains(root, 0)  << endl;   // false
//    cout << endl;

    // test the remove function
    cout << "remove:" << endl;
    remove(root, 91);
    remove(root, 29);
    remove(root, 55);

    cout << "after removing things:" << endl;
    print(root);
    cout << endl;
    cout << "size: " << size(root) << endl;

    return 0;
}
