/*
 * CS 106B/X, Marty Stepp
 *
 * This program contains code for various sorting algorithms
 * including bogo sort, selection sort, insertion sort,
 * recursive merge sort, and quick sort.
 */

#include <fstream>
#include <iomanip>
#include <iostream>
#include "console.h"
#include "filelib.h"
#include "random.h"
#include "vector.h"
#include "timer.h"
#include "support.h"
#include "shuffle.h"

using namespace std;

// constants
static const int INITIAL_SIZE = 9;         // starting size of array
static const int MAX_SIZE     = 10000000;   // largest length of data to sort  (try 100k for selection, 2-3m for merge)

// function prototype declarations
void bogoSort(Vector<int>& v);
void selectionSort(Vector<int>& v);
void insertionSort(Vector<int>& v);
void mergeSort(Vector<int>& v);
void quickSort(Vector<int>& v);
void swap(Vector<int>& v, int i, int j);

int main() {
    for (int N = INITIAL_SIZE; N <= MAX_SIZE; N *= 2) {
        // cout << "Creating the vector..." << endl;
        Vector<int> v;
        fillRandomIntVector(v, N);

        // perform the sort time how long it takes
        Timer tim(true);
        mergeSort(v);
        long elapsedTime = tim.stop();
        
        if (!isSorted(v)) {
            throw "Vector is not sorted!";
        }

        cout << "N=" << setw(8) << N << ", time=" << setw(5) << elapsedTime << endl;
    }

    return 0;
}

/*
 * Rearranges the elements of v into sorted order using
 * the bogo sort algorithm.
 */
void bogoSort(Vector<int>& v) {
    // TODO
}

/*
 * Rearranges the elements of v into sorted order using
 * the selection sort algorithm.
 */
void selectionSort(Vector<int>& v) {
    // TODO
}

/*
 * Rearranges the elements of v into sorted order using
 * the insertion sort algorithm.
 */
void insertionSort(Vector<int>& v) {
    // TODO
}

/*
 * Rearranges the elements of v into sorted order using
 * the merge sort algorithm.
 */
void mergeSort(Vector<int>& v) {
    // TODO
}

