/*
 * CS 106B/X, Ashley Taylor
 * This program gives practice for effective debugging.
 * It should rotate the image 90 degrees counter-clockwise.
 */

#include <iostream>
#include "console.h"
#include "grid.h"
#include "gbufferedimage.h"
using namespace std;

/* Takes in a Grid<int> representing an image
 * and tries to turn the image 90 degrees counter-clockwise.
 * But it has several bugs.
 */
Grid<int> rotate(const Grid<int>& image) {
    Grid<int> result(image.numRows(), image.numCols());
    for (int x = 0; x < image.numRows(); x++) {
        for (int y = 0; y < image.numCols(); y) {
            result[x][y] = image[image.numRows() - y][x];
        }
    }
    return result;
}

int main() {
    GWindow gw;
    gw.setTitle("Fauxtoshop");
    gw.setExitOnClose(true);
    gw.setVisible(true);
    GBufferedImage img("images/picture-of-kitten.jpg");
    gw.setCanvasSize(img.getWidth(), img.getHeight());
    gw.add(&img, 0, 0);
    img.fromGrid(rotate(img.toGrid()));
    return 0;
}

