/*
 * CS 106B/X, Ashley Taylor
 * This file contains several recursive function examples.
 * A recursive function is one that calls itself.
 * A recursive call often handles a small part of the overall problem,
 * leaving the rest to be handled by other self-calls.
 */

#include <fstream>
#include <iostream>
#include "console.h"
#include "filelib.h"
#include "strlib.h"
using namespace std;

void reverseLines(ifstream &input);
int convertFromBinary(string binary);

// A tester function for convertFromBinary
void binary_tester(string testCase, int expected) {
    int actual = convertFromBinary(testCase);
    cout << "Test case: " << testCase << "->" << expected;
    if (expected == actual) {
        cout << " PASSED" << endl;
    } else {
        cout << " FAILED and returned " << actual << " instead" << endl;
    }
}

int power(int base, int exp) {

    return 0;
}

// This function takes a string representation
// of a binary number and returns the number as an int
// e.g. 101 -> 5
//     1011 -> 11
// you can assume binary is a valid binary number
// (length > 0, only 0s and 1s)
int convertFromBinary(string binary) {
    int length = binary.length();
    if (length == 1) {
        return stringToInteger(binary);
    }
    string lastBit = binary.substr(length - 1);
    int lastBitValue = convertFromBinary(lastBit);
    return 2 * convertFromBinary(binary.substr(0, length - 1)) + lastBitValue;
}

// This function prints a file line by line
// in reverse order. Input should be an opened ifstream
void reverseLines(ifstream& input) {
    string line;
    if (getline(input, line)) {
        reverseLines(input);
        cout << line << endl;
    }
}

// This function will recursively crawl a given directory
// printing the files and subdirectories
// within each directory
void crawl(string name, string indent = "") {
    cout << indent << getTail(name) << endl;
    if (isDirectory(name)) {
        // need to include indent
        string subfile = listDirectory(name)[0];
        for (string subfile : listDirectory(name)) {
            crawl(name + "/" + subfile, indent + "    ");
        }
    }
}

int evenDigits(int num) {

    return 0;
}

int main() {
    cout << "power(2, 5) = " << power(2, 5) << endl;
    cout << "power(1, 9) = " << power(1, 9) << endl;
    cout << "power(9, 0) = " << power(9, 0) << endl;

//    binary_tester("0", 0);
//    binary_tester("101", 5);
//    binary_tester("100", 4);
//    binary_tester("001010", 10);

//    ifstream input;
//    input.open(string("poem.txt"));
//    reverseLines(input);

//    cout << endl << "Crawling Folders" << endl;
//    crawl("ParentFolder");

//    cout << endl << "Even Digits" << endl;
//    cout << "evenDigits(834116): " << evenDigits(834116) << endl;
//    cout << "evenDigits(413): " << evenDigits(413) << endl;
//    cout << "evenDigits(137): " << evenDigits(137) << endl;

    return 0;
}
