/**
 * File: draw-boxy-fractal.cpp
 * ---------------------------
 * drawBoxyFractal draws a collection of recursively layered squares
 * to form a fractal in two-dimensional space.
 */

#include <cmath>
using namespace std;

#include "gwindow.h"
#include "gevents.h"

static const double kCoreDimension = 120;
static const double kScale = 0.45;
static void drawFilledBox(GWindow& window, double cx, double cy, double dimension,
                          const string& fill, const string& border) {
    GRectangle bounds(cx - dimension/2, cy - dimension/2, dimension, dimension);
    window.setColor(fill);
    window.fillRect(bounds);
    window.setColor(border);
    window.drawRect(bounds);
}

static void drawBoxyFractal(GWindow& window, double cx, double cy,
                            double dimension, int order) {
    if (order >= 0) {
        drawFilledBox(window, cx, cy, dimension, "Gray", "Black");
        drawBoxyFractal(window, cx - dimension/2, cy + dimension/2, kScale * dimension, order - 1);
        drawBoxyFractal(window, cx + dimension/2, cy - dimension/2, kScale * dimension, order - 1);
        drawBoxyFractal(window, cx - dimension/2, cy - dimension/2, kScale * dimension, order - 1);
        drawBoxyFractal(window, cx + dimension/2, cy + dimension/2, kScale * dimension, order - 1);
    }
}

int main() {
    GWindow window(getScreenWidth()/2, getScreenHeight()/2);
    for (int order = 0; order <= 5; order++) {
        waitForClick();
        window.clear();
        drawBoxyFractal(window, window.getWidth()/2, window.getHeight()/2,
                        kCoreDimension, order);
    }
    waitForClick();
    window.close();
    return 0;
}
