/**
 * File: draw-coastline.cpp
 * ------------------------
 * Draws a recursion coastline as requested by Chapter 8, Problem 15
 * in the course reader.
 */

#include <cmath>
using namespace std;

#include "console.h"
#include "gwindow.h"
#include "gevents.h"
#include "random.h"

static GPoint drawCoastline(GWindow& window, GPoint pt,
                            double length, double theta, int order) {
    if (order == 0) return window.drawPolarLine(pt, length, theta);
    double angle = randomChance(0.5) ? 45 : -45;
    pt = drawCoastline(window, pt, length/3, theta, order - 1);
    pt = drawCoastline(window, pt, length * sqrt(2)/6, theta + angle, order - 1);
    pt = drawCoastline(window, pt, length * sqrt(2)/6, theta - angle, order - 1);
    return drawCoastline(window, pt, length/3, theta, order - 1);
}

int main() {
    GWindow window(getScreenWidth()/2, getScreenHeight()/2);
    GPoint middleLeft(0, window.getHeight()/2);
    cout << "This program draws a collections of recursion coastlines of increasing order." << endl;
    cout << "Click the mouse to advance the order and regenerate." << endl;
    for (int order = 0; order <= 6; order++) {
        waitForClick();
        window.setColor("White");
        window.fillRect(0, 0, getScreenWidth()/2, getScreenHeight()/2);
        window.setColor("Black");
        drawCoastline(window, middleLeft, window.getWidth(), 0, order);
    }
    waitForClick();
    window.close();
    return 0;
}
