/**
 * File: list-subsets.cpp
 * ----------------------
 * Expressing character sets as strings, list-subsets provided the recursive
 * listSubsets function, which prints out all of the subsets of a character set.
 */

#include <string>
#include <iostream>
using namespace std;

#include "console.h"

static void listSubsets(const string& prefix, const string& remaining) {
	if (remaining.empty()) {
		cout << prefix << endl;
		return;
	}
    
	listSubsets(prefix + remaining[0], remaining.substr(1));
	listSubsets(prefix, remaining.substr(1));
}

static void listSubsets(string str) {
	listSubsets("", str);
}

int main() {
    listSubsets("acbdef");
    return 0;
}
