/**
 * File: periodic-table.cpp
 * ------------------------
 * Pretending each of the symbols in the periodic table is
 * a letter of a new alphabet, this program prints out all
 * of the English words that can be constructed from these letters.
 *
 * For instance, using just the first 18 elements (H through Ar), there
 * are two words of length 11 or more:
 *
 *   NONAlCOHOLiC
 *   FOOLiSHNeSS
 *
 * If instead we allow all 118 symbols as letters, the number of English
 * words is much, much higher.
 */

#include <string>
#include <iostream>
using namespace std;

#include "console.h"
#include "vector.h"
#include "lexicon.h"

static const int kMinWordLength = 4;
static void printAllWords(const Lexicon& english, const Vector<string>& elements, const string& prefix) {
	if (!english.containsPrefix(prefix)) return;
	if (english.contains(prefix) && prefix.length() >= kMinWordLength) {
        cout << prefix << endl;
	}
	
    for (const string& element: elements) {
		printAllWords(english, elements, prefix + element);
	}
}

static void printAllWords(const Lexicon& english, const Vector<string>& elements) {
	printAllWords(english, elements, "");
}

int main() {
    Lexicon english("dictionary.txt");
    Vector<string> elements;
    elements += "H", "He";
    elements += "Li", "Be", "B", "C", "N", "O", "F", "Ne";
    elements += "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar";
    printAllWords(english, elements);
    return 0;
}
