/**
 * File: sparse-string-array-test.cpp
 * ----------------------------------
 * Test framework designed to exercise the most basic functionality
 * exported by sparse-string-array.h/cpp and its SparseStringArray class.
 */

#include <iostream>
#include "sparse-string-array.h"
#include "console.h"
using namespace std;

/**
 * Function: printSerialization
 * ----------------------------
 * Presents the serialization of all of the nonempty strings
 * housed within the supplied SparseStringArray.  All strings
 * are printed on the same line with no intervening spaces, and
 * a newline is printed after the serialization of the SparseStringArray
 * has been published.
 */
static void printSerialization(const SparseStringArray& ssa) {
    cout << "Serialization: ";
    for (int i = 0; i < ssa.size(); i++) {
        const string& s = ssa[i];
        if (!s.empty()) cout << s;
    }
    cout << endl;
}

/**
 * Function: main
 * --------------
 * Presents the entry point of the very simple test framework.
 */
int main() {
    SparseStringArray ssa(70000, 35);
    ssa[33001] = "need";
    ssa[58291] = "more";
    ssa[33000] = "Eye";
    ssa[33000] = "I";
    ssa[67899] = "cowbell!";
    printSerialization(ssa);
    return 0;
}
