/**
 * File: sparse-string-array.cpp
 * -----------------------------
 * Presents the implementation of the SparseStringArray.
 */

#include "sparse-string-array.h"
using namespace std;

SparseStringArray::SparseStringArray(int length, int groupSize) {

    this->length = length;
    this->groupSize = groupSize;
    numGroups = length / groupSize;
    groups = new group[numGroups];

    for (int group = 0; group < numGroups; group++) {
        groups[group].bitmap = new bool[groupSize];
        for (int i = 0; i < groupSize; i++) {
            groups[group].bitmap[i] = false;
        }
    }
}

SparseStringArray::~SparseStringArray() {
    for (int i = 0; i < numGroups; i++) {
        delete[] groups[i].bitmap;
    }

    delete[] groups;
}

int SparseStringArray::size() const {
    return length;
}

string& SparseStringArray::operator[](int index) {
    int groupIndex = index / groupSize;
    int bitmapIndex = index % groupSize;
    int vectorIndex = getVectorIndex(groupIndex, bitmapIndex);

    if (!groups[groupIndex].bitmap[bitmapIndex]) {
        groups[groupIndex].bitmap[bitmapIndex] = true;
        groups[groupIndex].strings.insert(vectorIndex, "");
    }

    return groups[groupIndex].strings[vectorIndex];
}

static const string kEmptyString;
const string& SparseStringArray::operator[](int index) const {
    int groupIndex = index / groupSize;
    int bitmapIndex = index % groupSize;
    if (!groups[groupIndex].bitmap[bitmapIndex]) {
        return kEmptyString;
    }

    int vectorIndex = getVectorIndex(groupIndex, bitmapIndex);
    return groups[groupIndex].strings[vectorIndex];
}

int SparseStringArray::getVectorIndex(int groupIndex, int bitmapIndex) const {
    int vectorIndex = 0;
    for (int i = 0; i < bitmapIndex; i++) {
        if (groups[groupIndex].bitmap[i]) {
            vectorIndex++;
        }
    }

    return vectorIndex;
}
