/**
 * File: hash-map-test.cpp
 * -----------------------
 * Exercises the HashMap type as I've defined it in my
 * own hash-map.h interface.  It's similar to hashmap.h as
 * exported by the CS106B/X libraries, but with an implementation
 * that's less concerned about being robust and more concerned with
 * illustrating how hashing and resolution by chaining works.
 */

#include <string>
#include <iostream>
#include <cassert>
#include "console.h"
#include "hash-map.h"
using namespace std;

/**
 * Function: integerTest
 * ---------------------
 * Simple function that confirms our HashMap works with primitive types
 * like ints.  If all goes well and the HashMap works as intended, integerTest
 * returns without printing anything at all.
 */
static void integerTest() {
    HashMap<int, int> ihm;
    ihm[45] = 70;
    assert(ihm.containsKey(45) && ihm.get(45) == 70 && ihm[45] == 70);
    ihm[45] = 700;
    assert(ihm.containsKey(45) && ihm.get(45) == 700 && ihm[45] == 700);
    assert(!ihm.containsKey(80) && ihm.get(80) == 0 && ihm[80] == 0 && ihm.containsKey(80));
    for (int key = 81; key < 700; key++) {
        assert(!ihm.containsKey(key) && ihm.get(key) == int());
    }
}

/**
 * Function: stringTest
 * --------------------
 * Exercises our HashMap to confirm it works for slightly more elaborate types,
 * like the C++ string class.  If all goes well and the HashMap works
 * as intended, stringTest returns without printing anything at all.
 */
static void stringTest() {
    HashMap<string, string> shm;
    shm["happy"] = "go lucky";
    assert(shm.containsKey("happy") && shm.get("happy") == "go lucky" && shm["happy"] == "go lucky");
    shm["happy"] = "as a clam";
    assert(shm.containsKey("happy") && shm.get("happy") == "as a clam" && shm["happy"] == "as a clam");
    assert(!shm.containsKey("running on") && shm.get("running on") == "" &&
           shm["running on"] == "" && shm.containsKey("running on"));
}

/**
 * Function: main
 * --------------
 * Defines the entry point of our test harness for HashMap. Note that this
 * program is designed to assert that the HashMap works without drama, and
 * provided there's no drama, there's no output at all (aside from the one
 * statement that everything went well).
 */
int main() {
    integerTest();
    stringTest();
    cout << "If you're seeing this, the HashMap works for primitives and for C++ strings." << endl;
    return 0;
}
