/*
 Demonstrate the censor table model -- creates a model with a table,
 and a censor model.
*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import javax.swing.event.*;
import java.io.*;

class CensorFrame extends JFrame {
	private BasicTableModel model;		// the real table model
	private CensorTableModel censorModel;	// censor model
	private JTable table, censorTable;	// standard JTables
	
	JButton columnButton;
	JButton rowButton;
	JButton deleteButton;
	JButton loadButton;
	JButton saveButton;
	JComponent container;
	
	Box searchPanel;
	JToggleButton searchToggle;
	JTextField censorText;
	JTable searchTable;
	JScrollPane searchScroll;
	
	// Listener for changes in the text field
	private class FieldListener implements DocumentListener {
		/*
		 We get these three notifications on changes
		 in the text field.
		*/
		public void insertUpdate(DocumentEvent e) {
			sendToModel();
		}
		public void changedUpdate(DocumentEvent e) {
			sendToModel();
		}
		public void removeUpdate(DocumentEvent e) {
			sendToModel();
		}
		
		// In all cases, send the new text to the censorModel
		public void sendToModel() {
			censorModel.setCensor(censorText.getText());
		}
	}
		
	public CensorFrame(String title, String filename) {
		super(title);
		container = (JComponent)getContentPane();
		container.setLayout(new BorderLayout());
		
		Box panel = Box.createVerticalBox();
		container.add(panel, BorderLayout.EAST);
		panel.add(new JLabel("Censor:"));
		censorText = new JTextField(10);
		censorText.setMaximumSize(new Dimension(140, 24));
		panel.add(censorText);
		
		censorText.getDocument().addDocumentListener(new FieldListener());
		
		
		// Create a standard table model and table
		model = new BasicTableModel();
		table = new JTable(model);
		JScrollPane scrollpane = new JScrollPane(table);
		scrollpane.setPreferredSize(new Dimension(300,200));
		container.add(scrollpane, BorderLayout.CENTER);
		
		// Create a second table layered through the censored model
		censorModel = new CensorTableModel(model);
		censorTable = new JTable(censorModel);
		scrollpane = new JScrollPane(censorTable);
		scrollpane.setPreferredSize(new Dimension(300,100));
		container.add(scrollpane, BorderLayout.SOUTH);
		
		if (filename != null) model.loadFile(new File(filename));
		
		rowButton = new JButton("Add Row");
		panel.add(rowButton);
		rowButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					int i = model.addRow();
					table.clearSelection();
					table.addRowSelectionInterval(i, i);
				}
			}
		);
		
		columnButton = new JButton("Add Column");
		panel.add(columnButton);
		columnButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String result = JOptionPane.showInputDialog("What name for the new column?");
					if (result != null) {
						model.addColumn(result);
					}
				}
			}
		);
		
		deleteButton = new JButton("Delete Row");
		panel.add(deleteButton);
		deleteButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					int row = table.getSelectedRow();
					if (row!=-1) model.deleteRow(row);
				}
			}
		);		
		
		loadButton = new JButton("Load File");
		panel.add(loadButton);
		loadButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					JFileChooser chooser = new JFileChooser();
					int status = chooser.showOpenDialog(CensorFrame.this);
					if (status == JFileChooser.APPROVE_OPTION) {
						model.loadFile(chooser.getSelectedFile());
					}
				}
			}
		);
		
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		pack();
		setVisible(true);
	}
	
	static public void main(String[] args) 
	{
		//new TableFrame("Table Frame");
		new CensorFrame("Censor Frame", "test.txt");
	}
}




		/*
		saveButton = new JButton("Save File");
		panel.add(saveButton);
		saveButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					JFileChooser chooser = new JFileChooser();
					int status = chooser.showSaveDialog(DBFrame.this);
					if (status == JFileChooser.APPROVE_OPTION) {
						db.saveToFile(chooser.getSelectedFile());
					}
				}
			}
		);
		
		
		//searchPanel = new Box(BoxLayout.Y_AXIS);
		
		searchPanel = Box.createVerticalBox();
		container.add(searchPanel, BorderLayout.SOUTH);
		
		searchToggle = new JCheckBox("Filter View");
		searchPanel.add(searchToggle);
		
		
		
		searchToggle.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					setSearch(searchScroll == null);
				}
			}
		);
		*/
	/*
	private void setSearch(boolean enable) {
		if (enable) {
			searchText.setEnabled(true);
			searchTable = new JTable(new FilteredDBModel(db, searchText));
			searchTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
			searchScroll = new JScrollPane(searchTable);
			searchScroll.setPreferredSize(new Dimension(300,100));
			
			searchPanel.add(searchScroll);
		}
		else {
			searchText.setEnabled(false);
			searchPanel.remove(searchScroll);
			searchScroll = null;
		}
		container.revalidate();
		//pack();
	}
	*/		

