import junit.framework.TestCase;


public class Count7Test extends TestCase {
	
	public void testCount7Basic() {
		// Basic cases
		assertEquals(2, Count7.count7(new int[] {1, 7, 3, 7}));
		assertEquals(2, Count7.count7(new int[] {7, 2, 7}));
		assertEquals(0, Count7.count7(new int[] {1, 2, 3}));
	}
	
	public void testCount7NoCount() {
		// The no-count feature
		assertEquals(1, Count7.count7(new int[] {1, 7, 7, 2}));
		assertEquals(2, Count7.count7(new int[] {7, 7, 1, 7, 7}));
		assertEquals(1, Count7.count7(new int[] {7, 7, 7}));
	}
	
	public void testCount7Edge() {
		// Weird and edge and cases
		assertEquals(1, Count7.count7(new int[] {7}));
		assertEquals(0, Count7.count7(new int[] {2}));
		assertEquals(0, Count7.count7(new int[] {}));
	}
}
