/*
 Deltas Class
 Deltas encapsulates a moderately complex computation as fodder for unit-testing.
 Does not have any data -- just a static deltas(int[]) method
 with this definition:
 -sums up the deltas between adjacent number pairs, so {1, 3, -1} -> 6
 -delta pairs where the first number is in the first 20% of the array
 count double, so {1, 2, 3, 4, 5} -> 5
 -deltas pairs where the first number is 0 do not count, so {1, 0, 10} -> 1
 */
public class Deltas {
	// Returns the deltas value of the given array.
	public static int deltas(int[] values) {
		int sum = 0;
		int doubleLength = values.length / 5; // part of array that counts double
		
		for (int i=0; i<values.length-1; i++) {
			int here = values[i];
			int next = values[i+1];
			
			// skip if 0, double if within doubleLength
			if (here != 0) {
				int delta = Math.abs(here-next);
				if (i<doubleLength) delta *= 2;
				sum += delta;
			}
		}
		return sum;
	}
}
