import junit.framework.TestCase;
import java.util.*;

/*
  DeltasTest -- unit tests for the Deltas class.
  
  There are three aspects:
  -basic summing of deltas
  -doubling the first 20% of the numbers
  -not counting deltas where the fist num is 0
  
  The basic tests work on a single problem aspect -- then harder tests
  try them in combination.
  
  In this case, Deltas includes only one method. If there were more methods,
  we would test them here too.
 */
public class DeltasTest extends TestCase {
	
	// basic -- no doubling, no zeros
	public void testDetalsBasic() {
		// len 4 -- no doubles
		assertEquals(4, Deltas.deltas(new int[] {1, 3, 2, 1} ));
		assertEquals(11, Deltas.deltas(new int[] {1, 5, -2, -2} ));
	}
	
	public void testDeltasZeros() {
		// try some zeros (also shows using first info String arg)
		int[] a = {1, 0, 0, 10} ;
		assertEquals("zeroes should not count:" + Arrays.toString(a),
				1, Deltas.deltas(a));
		
		int[] b = {0, 10, 1, 0} ;
		assertEquals("zeroes should not count:" + Arrays.toString(b),
				10, Deltas.deltas(b));
	}
	
	// bump the len up to 5,9,10 to check the doubling -- note the choices
	// of lengths 5,9,10 deliberately push on the "boundary" case of the doubling.
	public void testDeltasDoubling() {
		 // len 5 -- 1 double
		assertEquals(5, Deltas.deltas(new int[] {1, 2, 3, 4, 5} ));
		
		 // len 9 -- 1 double
		assertEquals(6, Deltas.deltas(new int[] {1, 3, 1, 1, 1, 1, 1, 1, 1} ));
		
		// len 10 -- 2 doubles
		assertEquals(8, Deltas.deltas(new int[] {1, 3, 1, 1, 1, 1, 1, 1, 1, 1} ));
	}

	// hard cases -- combine doubling with zeros, and weirder looking cases
	public void testDeltasHard() {
		 // len 5 1 double + 1 zero
		assertEquals(7, Deltas.deltas(new int[] {1, 3, 0, 1, 1, } ));
		
		 // len 7 1 double + some zeros
		assertEquals(14, Deltas.deltas(new int[] {1, 3, 0, 1, 2, 0, 5, 1 } ));
		
		 // 1 double + 1 zero cancels it
		assertEquals(2, Deltas.deltas(new int[] {0, 3, 1, 1, 1} ));
		
		 // siimple but weird edge cases
		assertEquals(0, Deltas.deltas(new int[] {} ));
		assertEquals(0, Deltas.deltas(new int[] {0} ));
		assertEquals(0, Deltas.deltas(new int[] {0,0,0} ));
		assertEquals(0, Deltas.deltas(new int[] {-1,-1,-1,-1,-1} ));
	}
}
