from util import *
import json

"""
Program: Joint Sample
---------------------
we can answer any probability question
with multivariate samples from the joint,
where conditioned variables match
"""
N_SAMPLES = 100000


def main():	
	# sample = make_sample()
	# pretty print this dictionary
	# print(json.dumps(sample, indent=4))
	
	for i in range(N_SAMPLES):
		sample = make_sample()
		print(sample)

def make_sample():
	"""
	Make Sample
	-------------------
	chose a single sample from the joint distribution
	based on the medical "Probabilistic Graphical Model"
	"""
	# prior on causal factors
	flu = bern(0.1)
	undergrad = bern(0.8)

	if flu == 1:
		fever = bern(0.9)
	else:
		fever = bern(0.05)

	# choose tired based on (undergrade and flu)
	if undergrad == 1 and flu == 1:   tired = bern(1.0)
	elif undergrad == 1 and flu == 0: tired = bern(0.8)
	elif undergrad == 0 and flu == 1: tired = bern(0.9)
	else:                             tired = bern(0.1)

	# a sample from the joint has an
	# assignment to *all* random variables
	return {
        'flu':flu, 
        'undergrad':undergrad, 
        'fever':fever, 
        'tired':tired
    }

if __name__ == '__main__':
	main()