from util import *
import json

"""
Program: Joint Sample
---------------------
we can answer any probability question
with multivariate samples from the joint,
where conditioned variables match
"""
N_SAMPLES = 100000


def main():	
	sample = make_sample()
	# pretty print this dictionary
	print(json.dumps(sample, indent=4))
	
	# for i in range(N_SAMPLES):
	# 	sample = make_sample()
	# 	print(sample)

def make_sample():
	"""
	Make Sample
	-------------------
	chose a single sample from the joint distribution
	based on the medical "Probabilistic Graphical Model"
	"""
	# prior on causal factors
	flu = bern(0.1)
	und = bern(0.8)

	# choose fever based on flue
	if flu == 1: fev = bern(0.9)
	else:        fev = bern(0.05)

	# choose tired based on (undergrade and flu)
	if und == 1 and flu == 1:   tir = bern(1.0)
	elif und == 1 and flu == 0: tir = bern(0.8)
	elif und == 0 and flu == 1: tir = bern(0.9)
	else:                       tir = bern(0.1)

	# a sample from the joint has an
	# assignment to *all* random variables
	return {
        'flu':flu, 
        'undergrad':und, 
        'fever':fev, 
        'tired':tir
    }

if __name__ == '__main__':
	main()