import random
from scipy import stats
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from tqdm import tqdm

n_betas = 5

def main():
    totals = []
    for i in tqdm(range(100000)):
        total = run_experiment()
        totals.append(total)
    plot_totals(totals)

def run_experiment():
    total = 0
    for i in range(n_betas):
        total += stats.beta.rvs(3,4)
    return total

def plot_totals(totals):
    ax = sns.histplot(totals)
    plt.show()


if __name__ == '__main__':
    main()