import random
from scipy import stats
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from tqdm import tqdm

n_unis = 10

def main():
    totals = []
    for i in tqdm(range(100000)):
        total = run_experiment()
        totals.append(total)
    plot_totals(totals)

def run_experiment():
    total = 0
    for i in range(n_unis):
        total += stats.uniform.rvs(0, 1)
    return total

def plot_totals(totals):
    range_start = n_unis *0.2
    range_end = n_unis * 0.8
    sns.histplot(totals, bins=100, binrange=(range_start, range_end))
    plt.show()


if __name__ == '__main__':
    main()