import random
from scipy import stats
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from tqdm import tqdm

def main():
    totals = []
    for i in tqdm(range(100000)):
        total = run_experiment()
        totals.append(total)
    # print(totals)
    plot_totals(totals)

def run_experiment():
    total = 0
    total += stats.uniform.rvs(0, 1)
    total += stats.uniform.rvs(0, 1)
    total += stats.uniform.rvs(0, 1)
    return total

def plot_totals(totals):
    ax = sns.histplot(totals, bins=50, binrange =(0, 3))
    plt.show()


if __name__ == '__main__':
    main()