/*
 * File: HangKarel.js
 * ------------------
 * This program plays a version of the classic Hangman game in which your
 * mission is to save Karel from being hung.
 */

import "file";
import "graphics";
import "RandomLib.js";

/* Constants */

const GWINDOW_WIDTH = 500;          /* Width of the graphics window        */
const GWINDOW_HEIGHT = 300;         /* Height of the graphics window       */
const LETTER_BASELINE = 10;         /* Distance from bottom to the letters */
const LETTER_POINTSIZE = 18;        /* Font size used for letter buttons   */
const WORD_BASELINE = 45;           /* Inset from bottom to secret word    */
const WORD_POINTSIZE = 36;          /* Font size for the secret word       */
const MESSAGE_BASELINE = 110;       /* Inset from bottom to message area   */
const MESSAGE_POINTSIZE = 60;       /* Font size for messages              */
const MAX_INCORRECT_GUESSES = 7;    /* Number of incorrect guesses allowed */
const INCORRECT_COLOR = "#FF9999";  /* Color used for incorrect guesses    */
const CORRECT_COLOR = "#009900";    /* Color used to mark correct guesses  */

/* Constants that define the Karel image */

const KAREL_IMAGE_TOP = 20;         /* Inset from top to Karel image       */
const BODY_WIDTH = 60;              /* Width of Karel's body               */
const BODY_HEIGHT = 80;             /* Height of Karel's body              */
const BODY_COLOR = "#EEEEEE";       /* Fill color for Karel's body         */
const UPPER_NOTCH = 15;             /* Size of the upper right notch       */
const LOWER_NOTCH = 10;             /* Size of the lower left notch        */
const SCREEN_WIDTH = 32;            /* Width of the screen rectangle       */
const SCREEN_HEIGHT = 45;           /* Height of the screen rectangle      */
const SCREEN_INSET_X = 13;          /* Inset from left to the screen       */
const SCREEN_INSET_Y = 12;          /* Inset from top to the screen        */
const SLOT_WIDTH = 15;              /* Horizontal length of the disk slot  */
const SLOT_INSET_X = 30;            /* Inset from left to the disk slot    */
const SLOT_INSET_Y = 68;            /* Inset from top to the disk slot     */
const LEFT_LEG_INSET_Y = 55;        /* Inset from top to the left leg      */
const RIGHT_LEG_INSET_X = 24;       /* Inset from left to the right leg    */
const LEG_BREADTH = 8;              /* Breadth across each leg segment     */
const LEG_LENGTH = 20;              /* Length of each leg segment          */
const FOOT_BREADTH = 8;             /* Breadth across each foot segment    */
const FOOT_LENGTH = 20;             /* Length of each foot (overlaps leg)  */

/* Main program */

function HangKarel() {
   var gw = GWindow(GWINDOW_WIDTH, GWINDOW_HEIGHT);
   var words = File.readLines("HangmanLexicon.txt");
   if (words === undefined) {
      console.log("The HangmanLexicon.txt file is missing.");
      return;
   }

   // You fill in the rest along with any helper and callback functions

}

