/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.java2js;

import edu.stanford.cs.java2js.JSBugCanvas;
import edu.stanford.cs.java2js.JSDialog;
import edu.stanford.cs.java2js.JSErrorDialogListener;
import edu.stanford.cs.java2js.JSMessageArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;

public class JSErrorDialog
extends JSDialog {
    public static final Color ERROR_BACKGROUND = new Color(0xFFCC33);
    public static final int DEFAULT_WIDTH = 350;
    public static final int DEFAULT_HEIGHT = 55;
    public static final int TOP_MARGIN = 15;
    public static final int LEFT_MARGIN = 1;
    private JSBugCanvas bugCanvas;
    private JSMessageArea messageArea;

    public JSErrorDialog(JComponent target) {
        this(target, true);
    }

    public JSErrorDialog(JComponent target, boolean isModal) {
        super(target, isModal);
        this.setLayout(new BorderLayout());
        this.setBackground(ERROR_BACKGROUND);
        this.bugCanvas = new JSBugCanvas();
        this.messageArea = new JSMessageArea();
        this.messageArea.setBackground(ERROR_BACKGROUND);
        this.add((Component)this.bugCanvas, "West");
        this.add((Component)this.messageArea, "Center");
        JSErrorDialogListener listener = new JSErrorDialogListener(this);
        this.bugCanvas.addMouseListener(listener);
        this.bugCanvas.addMouseMotionListener(listener);
        this.messageArea.addMouseListener(listener);
        this.messageArea.addMouseMotionListener(listener);
        this.setPreferredSize(new Dimension(350, 55));
    }

    public void setErrorMessage(String msg) {
        String style = msg.startsWith("<html>") ? "text/html" : "text/plain";
        Insets insets = new Insets(15, 1, 0, 0);
        this.messageArea.setMargin(insets);
        this.messageArea.setContentType(style);
        this.messageArea.setText(msg);
        this.messageArea.repaint();
    }
}

