/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.java2js;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.xml.bind.DatatypeConverter;

public class JSImage
extends BufferedImage {
    private String name;
    private static JPanel EMPTY_CONTAINER = new JPanel();
    private static HashMap<String, Image> imageTable = new HashMap();

    public JSImage(String src, int width, int height) {
        super(width, height, 2);
        this.getGraphics().drawImage(JSImage.staticImage(src), 0, 0, width, height, null);
        JSImage.loadImage(this);
    }

    public JSImage(String src) {
        this(src, JSImage.staticWidth(src), JSImage.staticHeight(src));
    }

    @Override
    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static int[][] createPixelArray(int width, int height) {
        return new int[height][width];
    }

    public int[][] getPixelArray() {
        int width = this.getWidth(EMPTY_CONTAINER);
        int height = this.getHeight(EMPTY_CONTAINER);
        int[] pixels = new int[width * height];
        int[][] array = new int[height][width];
        PixelGrabber pg = new PixelGrabber(this.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Transfer interrupted");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new RuntimeException("Transfer aborted");
        }
        int i = 0;
        while (i < height) {
            System.arraycopy(pixels, i * width, array[i], 0, width);
            ++i;
        }
        return array;
    }

    public static Image readDataImage(String url) {
        int p0 = url.indexOf(",") + 1;
        if (p0 == 0) {
            throw new RuntimeException("Malformed data URL");
        }
        byte[] data = DatatypeConverter.parseBase64Binary((String)url.substring(p0));
        return Toolkit.getDefaultToolkit().createImage(data);
    }

    public static boolean isComplete(Image image) {
        return true;
    }

    public static void addActionListener(Image image, ActionListener listener) {
    }

    private static int staticWidth(String src) {
        return JSImage.staticImage(src).getWidth(null);
    }

    private static int staticHeight(String src) {
        return JSImage.staticImage(src).getHeight(null);
    }

    private static Image staticImage(String src) {
        Image image = imageTable.get(src);
        if (image != null) {
            return image;
        }
        String url = src;
        if (url.startsWith("data:")) {
            image = JSImage.readDataImage(src);
        } else {
            if (JSImage.isReadable(src)) {
                try {
                    image = ImageIO.read(new URL("file:" + src));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            String tail = src.substring(src.lastIndexOf(47) + 1);
            if (JSImage.isReadable("images/" + tail)) {
                url = "file:images/" + tail;
            }
            try {
                image = ImageIO.read(new URL(url));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        JSImage.loadImage(image);
        imageTable.put(src, image);
        return image;
    }

    private static boolean isReadable(String filename) {
        try {
            return new File(filename).canRead();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void loadImage(Image image) {
        MediaTracker tracker = new MediaTracker(EMPTY_CONTAINER);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Image loading process interrupted");
        }
    }
}

