/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.java2js;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;

class JSProgramLayout
implements LayoutManager {
    private static final int MINIMUM = 0;
    private static final int PREFERRED = 1;
    private Component controls;
    private HashMap<Component, String> names = new HashMap();

    @Override
    public void addLayoutComponent(String constraints, Component comp) {
        this.names.put(comp, constraints);
        if (constraints.equals("controls")) {
            this.controls = comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.names.remove(comp);
        if (comp == this.controls) {
            this.controls = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, 1);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, int mode) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int width = 0;
            int height = 0;
            int extra = 0;
            int nComps = target.getComponentCount();
            int i = 0;
            while (i < nComps) {
                Component comp = target.getComponent(i);
                String name = this.names.get(comp);
                if (name.equals("controls")) {
                    extra = this.getModeSize((Component)comp, (int)mode).height;
                    --nComps;
                } else {
                    Dimension size = this.getModeSize(comp, mode);
                    width += size.width;
                    height = Math.max(height, size.height);
                }
                ++i;
            }
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom + extra);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Rectangle frame = target.getBounds();
            frame.x += insets.left;
            frame.y += insets.top;
            frame.width -= insets.left + insets.right;
            frame.height -= insets.top + insets.bottom;
            Dimension size = new Dimension(0, 0);
            int nComps = target.getComponentCount();
            if (this.controls != null) {
                size = this.controls.getPreferredSize();
                --nComps;
            }
            if (nComps == 0) {
                return;
            }
            frame.height -= size.height;
            int x = frame.x;
            int dx = frame.width / nComps;
            Component[] componentArray = target.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                String name = this.names.get(comp);
                Rectangle r = new Rectangle(frame);
                if (name.equals("controls")) {
                    r = new Rectangle(frame.x, frame.y + frame.height, frame.width, size.height);
                } else {
                    r = new Rectangle(x, frame.y, dx, frame.height);
                    x += dx;
                }
                comp.setBounds(r.x, r.y, r.width, r.height);
                ++n2;
            }
        }
    }

    private Dimension getModeSize(Component comp, int mode) {
        if (mode == 0) {
            return comp.getMinimumSize();
        }
        if (mode == 1) {
            return comp.getPreferredSize();
        }
        throw new RuntimeException("Illegal mode");
    }
}

