/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jscontrols;

import edu.stanford.cs.jscontrols.JSControl;

public class NewControl
extends JSControl {
    public static final String CONTROL = "data:image/png;base64,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";
    public static final String PRESSED = "data:image/png;base64,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";
    public static final String ROLLOVER = "data:image/png;base64,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";
    public static final String DISABLED = "data:image/png;base64,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";

    public NewControl() {
        this.setName("New");
        this.setIcon(this.createImageIcon(CONTROL));
        this.setDisabledIcon(this.createImageIcon(DISABLED));
        this.setRolloverIcon(this.createImageIcon(ROLLOVER));
        this.setPressedIcon(this.createImageIcon(PRESSED));
    }
}

