/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jseditor;

import edu.stanford.cs.jseditor.JSEditorUndoHandler;
import edu.stanford.cs.jseditor.JSEditorUndoManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotUndoException;

class JSEditorRedoAction
extends AbstractAction {
    private JSEditorUndoHandler handler;
    private JSEditorUndoManager manager;

    public JSEditorRedoAction(JSEditorUndoHandler handler) {
        super("Redo");
        this.setEnabled(false);
        this.handler = handler;
        this.manager = handler.getUndoManager();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.manager.redo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
        this.update();
        this.handler.getUndoAction().update();
    }

    protected void update() {
        if (this.manager.canRedo()) {
            this.setEnabled(true);
            this.putValue("Name", this.manager.getRedoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }
}

