/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.parser;

import edu.stanford.cs.parser.IntList;
import edu.stanford.cs.utf8.UTF8;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CodeVector {
    private ArrayList<Integer> code = new ArrayList();
    private HashMap<String, Integer> labels = new HashMap();
    private HashMap<String, IntList> labelRefs = new HashMap();
    private HashMap<Integer, IntList> intRefs = new HashMap();
    private HashMap<String, IntList> stringRefs = new HashMap();
    private String source = null;
    private int labelCount = 0;

    public void addWord(int word) {
        this.code.add(word);
    }

    public void addInstruction(int op, int addr) {
        this.addWord(op << 24 | addr);
    }

    public int getCurrentAddress() {
        return this.code.size();
    }

    public String newLabel() {
        return "$" + this.labelCount++;
    }

    public void defineLabel(String label) {
        this.defineSymbol(label, this.getCurrentAddress());
    }

    public void defineSymbol(String label, int value) {
        this.labels.put(label, value);
    }

    public boolean isDefined(String label) {
        return this.labels.containsKey(label);
    }

    public int getLabel(String label) {
        if (this.labels.containsKey(label)) {
            return this.labels.get(label);
        }
        throw new RuntimeException("Undefined symbol " + label);
    }

    public int labelRef(String label) {
        if (this.labels.containsKey(label)) {
            return this.labels.get(label);
        }
        IntList refs = this.labelRefs.get(label);
        if (refs == null) {
            refs = new IntList();
            this.labelRefs.put(label, refs);
        }
        refs.add(this.code.size());
        return 0;
    }

    public int stringRef(String str) {
        IntList refs = this.stringRefs.get(str);
        if (refs == null) {
            refs = new IntList();
            this.stringRefs.put(str, refs);
        }
        refs.add(this.code.size());
        return 0;
    }

    public int intRef(int n) {
        IntList refs = this.intRefs.get(n);
        if (refs == null) {
            refs = new IntList();
            this.intRefs.put(n, refs);
        }
        refs.add(this.code.size());
        return 0;
    }

    public int[] getCode() {
        this.resolveReferences();
        int n = this.code.size();
        int[] array = new int[n];
        int i = 0;
        while (i < n) {
            array[i] = this.code.get(i);
            ++i;
        }
        return array;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    private void resolveReferences() {
        int addr;
        Iterator iterator;
        for (String label : this.labelRefs.keySet()) {
            if (this.labels.containsKey(label)) {
                IntList refs = this.labelRefs.get(label);
                int value = this.labels.get(label);
                iterator = refs.iterator();
                while (iterator.hasNext()) {
                    addr = (Integer)iterator.next();
                    this.code.set(addr, this.code.get(addr) + value);
                }
                continue;
            }
            throw new RuntimeException("Unresolved reference: " + label);
        }
        for (String str : this.stringRefs.keySet()) {
            int start = this.code.size();
            IntList refs = this.stringRefs.get(str);
            int[] words = UTF8.encode(str);
            int i = 0;
            while (i < words.length) {
                this.code.add(words[i]);
                ++i;
            }
            Iterator iterator2 = refs.iterator();
            while (iterator2.hasNext()) {
                int addr2 = (Integer)iterator2.next();
                this.code.set(addr2, this.code.get(addr2) + start);
            }
        }
        Iterator<Object> iterator3 = this.intRefs.keySet().iterator();
        while (iterator3.hasNext()) {
            int n = (Integer)iterator3.next();
            int start = this.code.size();
            IntList refs = this.intRefs.get(n);
            this.code.add(n);
            iterator = refs.iterator();
            while (iterator.hasNext()) {
                addr = (Integer)iterator.next();
                this.code.set(addr, this.code.get(addr) + start);
            }
        }
    }
}

