/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.sjs.SJSCommandMonitor;
import edu.stanford.cs.sjs.SJSInterpreter;
import edu.stanford.cs.sjs.SJSVM;
import edu.stanford.cs.svm.SVMConsoleListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SJSInterpreterMonitor
extends SVMConsoleListener
implements SJSCommandMonitor,
ChangeListener {
    private SJSInterpreter interpreter;
    private SJSVM svm;
    private boolean interactive;
    private boolean waiting;

    public SJSInterpreterMonitor(SJSInterpreter interpreter) {
        super(interpreter.getSVM());
        this.interpreter = interpreter;
        this.svm = (SJSVM)interpreter.getSVM();
        this.svm.addChangeListener(this);
        this.interactive = false;
        this.waiting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        SJSInterpreter sJSInterpreter = this.interpreter;
        synchronized (sJSInterpreter) {
            try {
                this.interpreter.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForCompletion() {
        SJSInterpreterMonitor sJSInterpreterMonitor = this;
        synchronized (sJSInterpreterMonitor) {
            while (true) {
                if (this.svm.isFinished()) {
                    if (!this.interactive) return;
                    this.interpreter.signalFinished();
                    return;
                }
                try {
                    this.waiting = true;
                    this.wait();
                    this.waiting = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setInteractive(boolean flag) {
        this.interactive = flag;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    protected void processConsoleLine(String line) {
        this.interpreter.processConsoleLine(line);
    }

    @Override
    public void showError(String msg, int line) {
        System.err.println(String.valueOf(line) + ": " + msg);
    }

    @Override
    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalFinished() {
        SJSInterpreterMonitor sJSInterpreterMonitor = this;
        synchronized (sJSInterpreterMonitor) {
            this.notify();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.svm.isFinished()) {
            if (this.waiting) {
                this.signalFinished();
            } else if (this.interactive) {
                this.interpreter.signalFinished();
            }
        }
    }
}

