/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMArray;
import edu.stanford.cs.svm.SVMClass;
import edu.stanford.cs.svm.SVMMethod;
import edu.stanford.cs.svm.SVMMethodClosure;
import edu.stanford.cs.svm.SVMObject;

class Core_select
extends SVMMethod {
    Core_select() {
    }

    @Override
    public void execute(SVM svm, Value receiver) {
        svm.checkSignature("Core.select", "**");
        Value ix = svm.pop();
        Value obj = receiver == null ? svm.pop() : receiver;
        int type = obj.getType();
        if (type == 83) {
            String s = obj.getStringValue();
            if (ix.getType() == 83) {
                String name = ix.getStringValue();
                if (name.equals("length")) {
                    svm.pushInteger(s.length());
                    return;
                }
                SVMMethodClosure mc = new SVMMethodClosure(obj, "String", name);
                svm.push(Value.createObject(mc, "MethodClosure"));
                return;
            }
            int index = ix.getIntegerValue();
            int n = s.length();
            if (index < 0) {
                index += n;
            }
            if (index < 0 || index >= n) {
                throw new RuntimeException("String index out of bounds");
            }
            svm.pushString(s.substring(index, index + 1));
            return;
        }
        if (type == 79) {
            String cname = obj.getClassName();
            if (cname.equals("Array")) {
                SVMArray array = (SVMArray)obj.getValue();
                if (ix.getType() == 83) {
                    String name = ix.getStringValue();
                    if (name.equals("length")) {
                        svm.pushInteger(array.size());
                        return;
                    }
                    SVMMethodClosure mc = new SVMMethodClosure(obj, "Array", name);
                    svm.push(Value.createObject(mc, "MethodClosure"));
                } else {
                    svm.push((Value)array.get(ix.getIntegerValue()));
                }
            } else if (cname.equals("Object") || cname.equals("Map")) {
                SVMObject map = (SVMObject)obj.getValue();
                Value v = (Value)map.get(ix.getStringValue());
                svm.push(v == null ? Value.UNDEFINED : v);
            } else {
                String name = ix.getStringValue();
                Value prop = obj.getProperty(name);
                if (prop != null) {
                    svm.push(prop);
                } else {
                    SVMClass c;
                    if (cname.equals("Class")) {
                        cname = (String)obj.getValue();
                        obj = null;
                    }
                    if ((c = SVMClass.forName(cname)) == null) {
                        throw new RuntimeException("Undefined class " + cname);
                    }
                    SVMMethod m = null;
                    try {
                        m = c.getMethod(name);
                    }
                    catch (Exception ex) {
                        svm.push(Value.UNDEFINED);
                        return;
                    }
                    if (m == null) {
                        throw new RuntimeException("Undefined method " + name);
                    }
                    if (m.isConstant()) {
                        m.execute(svm, null);
                        return;
                    }
                    SVMMethodClosure mc = new SVMMethodClosure(obj, cname, name);
                    svm.push(Value.createObject(mc, "MethodClosure"));
                }
            }
        } else if (type == 73 || type == 68) {
            if (ix.getType() == 83) {
                String name = ix.getStringValue();
                SVMMethodClosure mc = new SVMMethodClosure(obj, "Number", name);
                svm.push(Value.createObject(mc, "MethodClosure"));
                return;
            }
        } else {
            throw new RuntimeException("Illegal selection");
        }
    }
}

